<?php
// Nouveau système de passage à la question suivante - AJAX
require_once 'includes/db.php';

// Démarrer la session si elle n'est pas déjà démarrée
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Vérifier que c'est une requête POST
if (!isset($_SERVER['REQUEST_METHOD']) || $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Méthode non autorisée']);
    exit;
}

// Vérifier que l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Non connecté']);
    exit;
}

// Vérifier que le quiz est démarré
if (!isset($_SESSION['quiz_started']) || !$_SESSION['quiz_started']) {
    http_response_code(400);
    echo json_encode(['error' => 'Quiz non démarré']);
    exit;
}

try {
    $question_idx = isset($_SESSION['quiz_question_idx']) ? $_SESSION['quiz_question_idx'] : 0;
    $phase = $_SESSION['quiz_phase'];
    
    // Si la phase était "Match pour la 3e place", utiliser "Finale" (car combinées)
    if ($phase === 'Match pour la 3e place') {
        $phase = 'Finale';
    }
    
    // Réinitialiser le feedback
    $_SESSION['quiz_show_feedback'] = false;
    unset($_SESSION['quiz_current_question_id']);
    unset($_SESSION['quiz_validation_result']);
    
    // Déterminer le nombre total de questions pour cette phase
    $total_questions = 15; // Par défaut
    if (isset($_SESSION['quiz_questions'][$phase])) {
        $total_questions = count($_SESSION['quiz_questions'][$phase]);
    }
    
    // Vérifier si c'est la dernière question
    if ($question_idx >= ($total_questions - 1)) {
        // C'est la dernière question - TERMINER LE QUIZ
        $action = 'quiz_completed';
        
        // Calculer le score final
        $score = 0;
        foreach ($_SESSION['quiz_answers'] as $qid => $user_answer) {
            $stmt = $mysqli->prepare("SELECT answer, option1, option2, option3, option4 FROM quizz_questions WHERE id = ?");
            $stmt->bind_param('i', $qid);
            $stmt->execute();
            $result = $stmt->get_result();
            $question = $result->fetch_assoc();
            $stmt->close();
            
            if ($question) {
                $correct_answer_text = '';
                
                // Vérifier si c'est une lettre (A, B, C, D) ou du texte direct
                if (in_array($question['answer'], ['A', 'B', 'C', 'D'])) {
                    // Convertir la lettre de réponse en texte
                    switch($question['answer']) {
                        case 'A':
                            $correct_answer_text = $question['option1'];
                            break;
                        case 'B':
                            $correct_answer_text = $question['option2'];
                            break;
                        case 'C':
                            $correct_answer_text = $question['option3'];
                            break;
                        case 'D':
                            $correct_answer_text = $question['option4'];
                            break;
                    }
                } else {
                    // C'est déjà du texte direct
                    $correct_answer_text = $question['answer'];
                }
                
                // Comparer avec le texte de la réponse
                if ($user_answer === $correct_answer_text) {
                    $score += 2;
                }
            }
        }
        
        // Sauvegarder le score final
        $stmt = $mysqli->prepare('UPDATE quizz_results_phases SET score = ?, completed_at = UTC_TIMESTAMP(), locked = 1 WHERE user_id = ? AND phase = ?');
        $stmt->bind_param('iis', $score, $_SESSION['user_id'], $phase);
        $stmt->execute();
        $stmt->close();
        
        // Nettoyer la session
        unset($_SESSION['quiz_started']);
        unset($_SESSION['quiz_phase']);
        unset($_SESSION['quiz_question_idx']);
        unset($_SESSION['quiz_answers']);
        unset($_SESSION['quiz_start_time']);
        unset($_SESSION['quiz_questions']);
        unset($_SESSION['quiz_current_question_id']);
        
        echo json_encode([
            'success' => true,
            'action' => 'quiz_completed',
            'score' => $score,
            'message' => 'Quiz terminé! Score: ' . $score . ' points'
        ]);
        exit;
    }
    
    // Passer à la question suivante
    $_SESSION['quiz_question_idx'] = $question_idx + 1;
    $action = 'next_question';
    
    // Récupérer les questions depuis la session
    if (isset($_SESSION['quiz_questions'][$phase])) {
        $questions = $_SESSION['quiz_questions'][$phase];
    } else {
        // Si les questions ne sont pas en session, erreur
        throw new Exception('Questions non trouvées en session');
    }
    
    // Vérifier que l'index est valide
    if ($_SESSION['quiz_question_idx'] >= count($questions)) {
        throw new Exception('Index de question invalide');
    }
    
    // Récupérer la nouvelle question
    $new_question = $questions[$_SESSION['quiz_question_idx']];
    
    // Sauvegarder l'index et la nouvelle question dans la base de données
    $stmt = $mysqli->prepare('UPDATE quizz_results_phases SET current_question_idx = ?, current_question_id = ? WHERE user_id = ? AND phase = ?');
    if ($stmt) {
        $stmt->bind_param('iisi', $_SESSION['quiz_question_idx'], $new_question['id'], $_SESSION['user_id'], $phase);
        $stmt->execute();
        $stmt->close();
    }
    
    // Mettre à jour la session avec la nouvelle question
    $_SESSION['quiz_current_question_id'] = $new_question['id'];
    
    // Retourner la réponse JSON
    echo json_encode([
        'success' => true,
        'action' => $action,
        'question_idx' => $_SESSION['quiz_question_idx'],
        'message' => 'Question suivante'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Erreur serveur: ' . $e->getMessage()]);
}

// Ne pas fermer la connexion ici car elle peut être utilisée ailleurs
// $mysqli->close();
?>
