<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: welcome.php');
    exit;
}

require_once 'includes/db.php';
require_once 'includes/language.php';

$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'];

// Récupérer les informations de l'utilisateur
$stmt = $mysqli->prepare("SELECT username, email, site, ville, departement, photo FROM Users WHERE id = ?");
if (!$stmt) {
    die('Erreur de préparation de la requête: ' . $mysqli->error);
}
$stmt->bind_param('i', $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

// Extraire les initiales du nom et prénom
function getInitials($username) {
    $parts = explode(' ', trim($username));
    $initials = '';
    foreach ($parts as $part) {
        if (!empty($part)) {
            $initials .= strtoupper(substr($part, 0, 1));
        }
    }
    // Limiter à 2 initiales maximum
    return substr($initials, 0, 2);
}

$user_initials = getInitials($user['username']);
$has_photo = !empty($user['photo']) && file_exists('assets/img/upload/' . $user['photo']);

$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
?>
<?php include 'templates/header.php'; ?>

<style>
.profile-container {
    max-width: 900px;
    margin: 0 auto;
    padding: 20px;
}

.profile-header {
    background: linear-gradient(135deg, #3db568 0%, #2e7c55 100%);
    border-radius: 20px;
    padding: 40px;
    text-align: center;
    color: white;
    margin-bottom: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.profile-photo-container {
    position: relative;
    display: inline-block;
    margin-bottom: 20px;
}

.profile-photo {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    border: 5px solid white;
    object-fit: cover;
    box-shadow: 0 8px 25px rgba(0,0,0,0.3);
    transition: transform 0.3s ease;
    display: block;
}

.profile-photo:hover {
    transform: scale(1.05);
}

.profile-initials {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    border: 5px solid white;
    box-shadow: 0 8px 25px rgba(0,0,0,0.3);
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #ffb300 0%, #ff8c00 100%);
    color: white;
    font-size: 3.5rem;
    font-weight: 800;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    transition: transform 0.3s ease;
}

.profile-initials:hover {
    transform: scale(1.05);
}

.photo-upload-btn {
    position: absolute;
    bottom: 10px;
    right: 10px;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #ffb300;
    border: 3px solid white;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
}

.photo-upload-btn:hover {
    background: #ff8c00;
    transform: scale(1.1);
}

.profile-name {
    font-size: 2rem;
    font-weight: 800;
    margin-bottom: 10px;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
}

.profile-info {
    font-size: 1.1rem;
    opacity: 0.9;
}

.profile-sections {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 30px;
    margin-bottom: 30px;
}

.profile-section {
    background: white;
    border-radius: 15px;
    padding: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    border: 1px solid #e5e7eb;
}

.section-title {
    font-size: 1.4rem;
    font-weight: 700;
    color: #1e3a8a;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.section-title i {
    color: #3b82f6;
}

.form-group {
    margin-bottom: 20px;
}

.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 8px;
    display: block;
}

.form-control {
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    padding: 12px 15px;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    outline: none;
}

.btn-primary {
    background: linear-gradient(135deg, #3b82f6 0%, #1e3a8a 100%);
    border: none;
    border-radius: 10px;
    padding: 12px 30px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
}

.btn-warning {
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    border: none;
    border-radius: 10px;
    padding: 12px 30px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-warning:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(245, 158, 11, 0.4);
}

@media (max-width: 768px) {
    .profile-sections {
        grid-template-columns: 1fr;
        gap: 20px;
    }
    
    .profile-header {
        padding: 30px 20px;
    }
    
    .profile-name {
        font-size: 1.5rem;
    }
}
</style>

<div class="profile-container">
    <!-- En-tête du profil -->
    <div class="profile-header">
        <div class="profile-photo-container">
            <?php if ($has_photo): ?>
                <img id="profilePhoto" 
                     src="assets/img/upload/<?= htmlspecialchars($user['photo']) ?>" 
                     alt="Photo de profil" 
                     class="profile-photo">
            <?php else: ?>
                <div id="profileInitials" class="profile-initials">
                    <?= htmlspecialchars($user_initials) ?>
                </div>
            <?php endif; ?>
            <button type="button" class="photo-upload-btn" onclick="document.getElementById('photoInput').click()">
                <i class="fas fa-camera"></i>
            </button>
        </div>
        <input type="file" id="photoInput" accept="image/*" style="display: none;" onchange="uploadPhoto()">
        
        <h1 class="profile-name"><?= htmlspecialchars($user['username']) ?></h1>
        <div class="profile-info">
            <i class="fas fa-envelope"></i> <?= htmlspecialchars($user['email']) ?>
            <?php if ($user['ville']): ?>
                <br><i class="fas fa-map-marker-alt"></i> <?= htmlspecialchars($user['ville']) ?>
            <?php endif; ?>
            <?php if ($user['departement']): ?>
                <br><i class="fas fa-building"></i> <?= htmlspecialchars($user['departement']) ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Sections du profil -->
    <div class="profile-sections">
        <!-- Section Informations personnelles -->
        <div class="profile-section">
            <h3 class="section-title">
                <i class="fas fa-user"></i>
                Informations personnelles
            </h3>
            <form id="profileForm">
                <div class="form-group">
                    <label for="username" class="form-label"><?= __('username') ?></label>
                    <input type="text" class="form-control" id="username" name="username" 
                           value="<?= htmlspecialchars($user['username']) ?>" required>
                </div>
                
                <div class="form-group">
                    <label for="email" class="form-label"><?= __('email') ?></label>
                    <input type="email" class="form-control" id="email" name="email" 
                           value="<?= htmlspecialchars($user['email']) ?>" required>
                </div>
                
                <div class="form-group">
                    <label for="ville" class="form-label"><?= __('city') ?></label>
                    <select class="form-control" id="ville" name="ville" data-live-search="true">
                        <option value="">-- Sélectionner une ville --</option>
                        <option value="Casablanca" <?= $user['ville'] === 'Casablanca' ? 'selected' : '' ?>>Casablanca</option>
                        <option value="Rabat" <?= $user['ville'] === 'Rabat' ? 'selected' : '' ?>>Rabat</option>
                        <option value="Fès" <?= $user['ville'] === 'Fès' ? 'selected' : '' ?>>Fès</option>
                        <option value="Marrakech" <?= $user['ville'] === 'Marrakech' ? 'selected' : '' ?>>Marrakech</option>
                        <option value="Agadir" <?= $user['ville'] === 'Agadir' ? 'selected' : '' ?>>Agadir</option>
                        <option value="Tanger" <?= $user['ville'] === 'Tanger' ? 'selected' : '' ?>>Tanger</option>
                        <option value="Meknès" <?= $user['ville'] === 'Meknès' ? 'selected' : '' ?>>Meknès</option>
                        <option value="Oujda" <?= $user['ville'] === 'Oujda' ? 'selected' : '' ?>>Oujda</option>
                        <option value="Kénitra" <?= $user['ville'] === 'Kénitra' ? 'selected' : '' ?>>Kénitra</option>
                        <option value="Tétouan" <?= $user['ville'] === 'Tétouan' ? 'selected' : '' ?>>Tétouan</option>
                        <option value="Safi" <?= $user['ville'] === 'Safi' ? 'selected' : '' ?>>Safi</option>
                        <option value="Mohammedia" <?= $user['ville'] === 'Mohammedia' ? 'selected' : '' ?>>Mohammedia</option>
                        <option value="Khouribga" <?= $user['ville'] === 'Khouribga' ? 'selected' : '' ?>>Khouribga</option>
                        <option value="Beni Mellal" <?= $user['ville'] === 'Beni Mellal' ? 'selected' : '' ?>>Beni Mellal</option>
                        <option value="El Jadida" <?= $user['ville'] === 'El Jadida' ? 'selected' : '' ?>>El Jadida</option>
                        <option value="Taza" <?= $user['ville'] === 'Taza' ? 'selected' : '' ?>>Taza</option>
                        <option value="Nador" <?= $user['ville'] === 'Nador' ? 'selected' : '' ?>>Nador</option>
                        <option value="Settat" <?= $user['ville'] === 'Settat' ? 'selected' : '' ?>>Settat</option>
                        <option value="Larache" <?= $user['ville'] === 'Larache' ? 'selected' : '' ?>>Larache</option>
                        <option value="Ksar El Kebir" <?= $user['ville'] === 'Ksar El Kebir' ? 'selected' : '' ?>>Ksar El Kebir</option>
                        <option value="Khemisset" <?= $user['ville'] === 'Khemisset' ? 'selected' : '' ?>>Khemisset</option>
                        <option value="Guelmim" <?= $user['ville'] === 'Guelmim' ? 'selected' : '' ?>>Guelmim</option>
                        <option value="Berrechid" <?= $user['ville'] === 'Berrechid' ? 'selected' : '' ?>>Berrechid</option>
                        <option value="Ouarzazate" <?= $user['ville'] === 'Ouarzazate' ? 'selected' : '' ?>>Ouarzazate</option>
                        <option value="Errachidia" <?= $user['ville'] === 'Errachidia' ? 'selected' : '' ?>>Errachidia</option>
                        <option value="Essaouira" <?= $user['ville'] === 'Essaouira' ? 'selected' : '' ?>>Essaouira</option>
                        <option value="Dakhla" <?= $user['ville'] === 'Dakhla' ? 'selected' : '' ?>>Dakhla</option>
                        <option value="Laâyoune" <?= $user['ville'] === 'Laâyoune' ? 'selected' : '' ?>>Laâyoune</option>
                        <option value="Tiznit" <?= $user['ville'] === 'Tiznit' ? 'selected' : '' ?>>Tiznit</option>
                        <option value="Sidi Kacem" <?= $user['ville'] === 'Sidi Kacem' ? 'selected' : '' ?>>Sidi Kacem</option>
                        <option value="Azrou" <?= $user['ville'] === 'Azrou' ? 'selected' : '' ?>>Azrou</option>
                        <option value="Ifrane" <?= $user['ville'] === 'Ifrane' ? 'selected' : '' ?>>Ifrane</option>
                        <option value="Chefchaouen" <?= $user['ville'] === 'Chefchaouen' ? 'selected' : '' ?>>Chefchaouen</option>
                        <option value="Autre" <?= $user['ville'] === 'Autre' ? 'selected' : '' ?>>Autre</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="departement" class="form-label"><?= __('department') ?></label>
                    <select class="form-control" id="departement" name="departement">
                        <option value="">-- Sélectionner un département --</option>
                        <option value="CREDIT CONSO" <?= $user['departement'] === 'CREDIT CONSO' ? 'selected' : '' ?>>CREDIT CONSO</option>
                        <option value="PRODUCTION & APPUI COMMERCIAL" <?= $user['departement'] === 'PRODUCTION & APPUI COMMERCIAL' ? 'selected' : '' ?>>PRODUCTION & APPUI COMMERCIAL</option>
                        <option value="OPC" <?= $user['departement'] === 'OPC' ? 'selected' : '' ?>>OPC</option>
                        <option value="RESSOURCES HUMAINES" <?= $user['departement'] === 'RESSOURCES HUMAINES' ? 'selected' : '' ?>>RESSOURCES HUMAINES</option>
                        <option value="CORPORATE BANKING" <?= $user['departement'] === 'CORPORATE BANKING' ? 'selected' : '' ?>>CORPORATE BANKING</option>
                        <option value="CONFORMITE" <?= $user['departement'] === 'CONFORMITE' ? 'selected' : '' ?>>CONFORMITE</option>
                        <option value="RETAIL BANKING" <?= $user['departement'] === 'RETAIL BANKING' ? 'selected' : '' ?>>RETAIL BANKING</option>
                        <option value="LEASING" <?= $user['departement'] === 'LEASING' ? 'selected' : '' ?>>LEASING</option>
                        <option value="DSI" <?= $user['departement'] === 'DSI' ? 'selected' : '' ?>>DSI</option>
                        <option value="IMEX" <?= $user['departement'] === 'IMEX' ? 'selected' : '' ?>>IMEX</option>
                        <option value="ACHATS" <?= $user['departement'] === 'ACHATS' ? 'selected' : '' ?>>ACHATS</option>
                        <option value="FINANCE PARTICIPATIVE" <?= $user['departement'] === 'FINANCE PARTICIPATIVE' ? 'selected' : '' ?>>FINANCE PARTICIPATIVE</option>
                        <option value="RECOUVREMENT" <?= $user['departement'] === 'RECOUVREMENT' ? 'selected' : '' ?>>RECOUVREMENT</option>
                        <option value="SECURITIES SERVICES" <?= $user['departement'] === 'SECURITIES SERVICES' ? 'selected' : '' ?>>SECURITIES SERVICES</option>
                        <option value="BANQUE PRIVEE" <?= $user['departement'] === 'BANQUE PRIVEE' ? 'selected' : '' ?>>BANQUE PRIVEE</option>
                        <option value="SECURITE PHYSIQUE" <?= $user['departement'] === 'SECURITE PHYSIQUE' ? 'selected' : '' ?>>SECURITE PHYSIQUE</option>
                        <option value="RISQUES" <?= $user['departement'] === 'RISQUES' ? 'selected' : '' ?>>RISQUES</option>
                        <option value="FINANCE" <?= $user['departement'] === 'FINANCE' ? 'selected' : '' ?>>FINANCE</option>
                        <option value="EXPERIENCE CLIENT & QUALITE" <?= $user['departement'] === 'EXPERIENCE CLIENT & QUALITE' ? 'selected' : '' ?>>EXPERIENCE CLIENT & QUALITE</option>
                        <option value="TRANSFORMATION ET EFFICACITE OPERATIONNELLE" <?= $user['departement'] === 'TRANSFORMATION ET EFFICACITE OPERATIONNELLE' ? 'selected' : '' ?>>TRANSFORMATION ET EFFICACITE OPERATIONNELLE</option>
                        <option value="ALM TREASURY" <?= $user['departement'] === 'ALM TREASURY' ? 'selected' : '' ?>>ALM TREASURY</option>
                        <option value="LOCAL CAPITAL MARKET" <?= $user['departement'] === 'LOCAL CAPITAL MARKET' ? 'selected' : '' ?>>LOCAL CAPITAL MARKET</option>
                        <option value="COMMUNICATION" <?= $user['departement'] === 'COMMUNICATION' ? 'selected' : '' ?>>COMMUNICATION</option>
                        <option value="PROGRAMME SAB" <?= $user['departement'] === 'PROGRAMME SAB' ? 'selected' : '' ?>>PROGRAMME SAB</option>
                        <option value="DIGITAL FACTORY" <?= $user['departement'] === 'DIGITAL FACTORY' ? 'selected' : '' ?>>DIGITAL FACTORY</option>
                        <option value="MONETIQUE" <?= $user['departement'] === 'MONETIQUE' ? 'selected' : '' ?>>MONETIQUE</option>
                        <option value="AFFAIRES JURIDIQUES" <?= $user['departement'] === 'AFFAIRES JURIDIQUES' ? 'selected' : '' ?>>AFFAIRES JURIDIQUES</option>
                        <option value="DIRECTION GENERALE" <?= $user['departement'] === 'DIRECTION GENERALE' ? 'selected' : '' ?>>DIRECTION GENERALE</option>
                        <option value="CDO" <?= $user['departement'] === 'CDO' ? 'selected' : '' ?>>CDO</option>
                        <option value="INSPECTION GENERALE" <?= $user['departement'] === 'INSPECTION GENERALE' ? 'selected' : '' ?>>INSPECTION GENERALE</option>
                        <option value="ENGAGEMENT" <?= $user['departement'] === 'ENGAGEMENT' ? 'selected' : '' ?>>ENGAGEMENT</option>
                        <option value="PILOTAGE STRATEGIQUE" <?= $user['departement'] === 'PILOTAGE STRATEGIQUE' ? 'selected' : '' ?>>PILOTAGE STRATEGIQUE</option>
                        <option value="Association des Retraités BMCI" <?= $user['departement'] === 'Association des Retraités BMCI' ? 'selected' : '' ?>>Association des Retraités BMCI</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-save"></i> <?= __('save_changes') ?>
                </button>
            </form>
        </div>

        <!-- Section Sécurité -->
        <div class="profile-section">
            <h3 class="section-title">
                <i class="fas fa-shield-alt"></i>
                Sécurité
            </h3>
            <form id="passwordForm">
                <div class="form-group">
                    <label for="newPassword" class="form-label"><?= __('new_password') ?></label>
                    <input type="password" class="form-control" id="newPassword" name="newPassword" required>
                </div>
                
                <div class="form-group">
                    <label for="confirmPassword" class="form-label"><?= __('confirm_password') ?></label>
                    <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" required>
                </div>
                
                <button type="submit" class="btn btn-warning w-100">
                    <i class="fas fa-key"></i> <?= __('change_password') ?>
                </button>
            </form>
        </div>
    </div>
</div>

<script>
const base = "<?= $base ?>";

// Initialiser la recherche dans la liste des villes
$(document).ready(function() {
    // Fonction de recherche simple pour la liste des villes
    $('#ville').on('focus', function() {
        $(this).attr('size', '10');
    }).on('blur', function() {
        $(this).attr('size', '1');
    });
    
    // Recherche en temps réel
    $('#ville').on('keyup', function() {
        const searchTerm = $(this).val().toLowerCase();
        const options = $(this).find('option');
        
        options.each(function() {
            const optionText = $(this).text().toLowerCase();
            if (optionText.includes(searchTerm) || searchTerm === '') {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });
});

// Upload de photo
function uploadPhoto() {
    const fileInput = document.getElementById('photoInput');
    const file = fileInput.files[0];
    
    if (!file) return;
    
    const formData = new FormData();
    formData.append('photo', file);
    
    fetch(base + '/ajax/upload_photo.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const photoContainer = document.querySelector('.profile-photo-container');
            const initialsDiv = document.getElementById('profileInitials');
            
            if (initialsDiv) {
                // Remplacer les initiales par l'image
                initialsDiv.remove();
                const img = document.createElement('img');
                img.id = 'profilePhoto';
                img.src = 'assets/img/upload/' + data.filename;
                img.alt = 'Photo de profil';
                img.className = 'profile-photo';
                photoContainer.insertBefore(img, photoContainer.querySelector('.photo-upload-btn'));
            } else {
                // Mettre à jour l'image existante
                document.getElementById('profilePhoto').src = 'assets/img/upload/' + data.filename;
            }
            showToast('<?= __('photo_updated') ?>', 'success');
        } else {
            showToast(data.message, 'danger');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('<?= __('upload_error') ?>', 'danger');
    });
}

// Sauvegarde du profil
$('#profileForm').on('submit', function(e) {
    e.preventDefault();
    
    $.post(base + '/ajax/update_profile.php', $(this).serialize(), function(data) {
        if (data.success) {
            showToast('<?= __('profile_updated') ?>', 'success');
            // Mettre à jour le nom d'utilisateur dans la session si nécessaire
            if (data.new_username) {
                location.reload();
            }
        } else {
            showToast(data.message, 'danger');
        }
    }, 'json');
});

// Changement de mot de passe
$('#passwordForm').on('submit', function(e) {
    e.preventDefault();
    
    const newPassword = $('#newPassword').val();
    const confirmPassword = $('#confirmPassword').val();
    
    if (newPassword !== confirmPassword) {
        showToast('<?= __('passwords_not_match') ?>', 'danger');
        return;
    }
    
    $.post(base + '/ajax/change_password.php', $(this).serialize(), function(data) {
        if (data.success) {
            showToast('<?= __('password_changed') ?>', 'success');
            $('#passwordForm')[0].reset();
        } else {
            showToast(data.message, 'danger');
        }
    }, 'json');
});
</script>

<?php include 'templates/footer.php'; ?>
