<?php
date_default_timezone_set('Africa/Casablanca');

// Inclure le système de langue en premier
require_once 'includes/language.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require 'includes/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}
$user_id = $_SESSION['user_id'];

// Liste des équipes (3 lettres => nom, flag)
$equipes = [
    'MAR' => ['nom' => 'Maroc', 'flag' => 'ma'], 'MAL' => ['nom' => 'Mali', 'flag' => 'ml'], 'ZAM' => ['nom' => 'Zambie', 'flag' => 'zm'], 'COM' => ['nom' => 'Comores', 'flag' => 'km'],
    'EGY' => ['nom' => 'Égypte', 'flag' => 'eg'], 'RSA' => ['nom' => 'Afrique du Sud', 'flag' => 'za'], 'ANG' => ['nom' => 'Angola', 'flag' => 'ao'], 'ZIM' => ['nom' => 'Zimbabwe', 'flag' => 'zw'],
    'NGA' => ['nom' => 'Nigeria', 'flag' => 'ng'], 'TUN' => ['nom' => 'Tunisie', 'flag' => 'tn'], 'UGA' => ['nom' => 'Ouganda', 'flag' => 'ug'], 'TAN' => ['nom' => 'Tanzanie', 'flag' => 'tz'],
    'SEN' => ['nom' => 'Sénégal', 'flag' => 'sn'], 'COD' => ['nom' => 'RD Congo', 'flag' => 'cd'], 'BEN' => ['nom' => 'Bénin', 'flag' => 'bj'], 'BOT' => ['nom' => 'Botswana', 'flag' => 'bw'],
    'ALG' => ['nom' => 'Algérie', 'flag' => 'dz'], 'BFA' => ['nom' => 'Burkina Faso', 'flag' => 'bf'], 'EQG' => ['nom' => 'Guinée Équatoriale', 'flag' => 'gq'], 'SUD' => ['nom' => 'Soudan', 'flag' => 'sd'],
    'CIV' => ['nom' => "Côte d'Ivoire", 'flag' => 'ci'], 'CMR' => ['nom' => 'Cameroun', 'flag' => 'cm'], 'GAB' => ['nom' => 'Gabon', 'flag' => 'ga'], 'MOZ' => ['nom' => 'Mozambique', 'flag' => 'mz']
];

// Traductions des noms d'équipes en arabe
$equipes_ar = [
    'MAR' => 'المغرب', 'MAL' => 'مالي', 'ZAM' => 'زامبيا', 'COM' => 'جزر القمر',
    'EGY' => 'مصر', 'RSA' => 'جنوب أفريقيا', 'ANG' => 'أنغولا', 'ZIM' => 'زيمبابوي',
    'NGA' => 'نيجيريا', 'TUN' => 'تونس', 'UGA' => 'أوغندا', 'TAN' => 'تنزانيا',
    'SEN' => 'السنغال', 'COD' => 'جمهورية الكونغو الديمقراطية', 'BEN' => 'بنين', 'BOT' => 'بوتسوانا',
    'ALG' => 'الجزائر', 'BFA' => 'بوركينا فاسو', 'EQG' => 'غينيا الاستوائية', 'SUD' => 'السودان',
    'CIV' => 'ساحل العاج', 'CMR' => 'الكاميرون', 'GAB' => 'الغابون', 'MOZ' => 'موزمبيق'
];

// Fonction pour obtenir le nom de l'équipe selon la langue
function getTeamName($code, $current_lang) {
    global $equipes, $equipes_ar;
    if ($current_lang === 'ar') {
        return $equipes_ar[$code] ?? $equipes[$code]['nom'] ?? $code;
    } else {
        return $equipes[$code]['nom'] ?? $code;
    }
}

// Tri alphabétique avec accents
if (class_exists('Collator')) {
    $collator = new Collator('fr_FR');
    uasort($equipes, function($a, $b) use ($collator) {
        return $collator->compare($a['nom'], $b['nom']);
    });
} else {
    uasort($equipes, function($a, $b) {
        return strcmp($a['nom'], $b['nom']);
    });
}

// Deadline - Récupération depuis le même fichier que admin/configuration.php
$winner_deadline_file = __DIR__.'/includes/winner_deadline.txt';
$winner_deadline = '';
$winner_ferme = false;
if (file_exists($winner_deadline_file)) {
    $winner_deadline = trim(file_get_contents($winner_deadline_file));
    if (!empty($winner_deadline)) {
        // Format attendu: YYYY-MM-DDTHH:mm (format datetime-local)
        // Conversion pour la comparaison: YYYY-MM-DD HH:mm:ss
        $deadline = str_replace('T', ' ', $winner_deadline);
        // Ajouter les secondes si elles ne sont pas présentes
        if (strlen($deadline) == 16) { // Format YYYY-MM-DD HH:mm
            $deadline .= ':00';
        }
        if (date('Y-m-d H:i:s') >= $deadline) {
            $winner_ferme = true;
        }
    }
}

// Pronostic existant ?
$stmt = $mysqli->prepare('SELECT team FROM winner_predictions WHERE user_id = ?');
$stmt->bind_param('i', $user_id);
$stmt->execute();
$stmt->bind_result($pronostic);
$stmt->fetch();
$stmt->close();

include 'templates/header.php';
?>

<style>
/* Styles RTL pour l'arabe */
.lang-ar .flag-card {
    text-align: center;
}

.lang-ar .flag-card .fw-bold {
    text-align: center;
    direction: rtl;
}

.lang-ar .alert-info {
    text-align: center;
}

.lang-ar .alert-info .fw-bold {
    margin-right: 8px;
    margin-left: 0;
}

.lang-ar .alert-warning {
    text-align: center;
}
</style>

<div class="container py-4 page-pronostic-vainqueur">
  <h2 class="text-center mb-4" style="color:white;"><?= __('winner_question') ?></h2>
  <!-- <p class="text-center mb-2" style="color:#eee; font-size:0.95rem; margin-top:-10px;">Heure serveur : <?= date('d/m/Y H:i:s') ?></p> -->
  <p class="text-center mb-4" style="color:#eee; font-size:1rem; margin-top:-8px; line-height:1.7;"><?= __('winner_instructions_first') ?><br><?= __('winner_instructions') ?><br><?= __('winner_deadline_text') ?></p>
  <hr class="mb-4" style="border-top:2px solid white; width:120px;margin:auto;">

  <?php if ($winner_ferme): ?>
    <div class="alert alert-warning text-center mb-4">
      <strong><?= __('winner_predictions_closed') ?></strong><br>
      <?php if ($winner_deadline): ?>
        <?= __('deadline') ?> : <?= date(($current_lang === 'ar') ? 'd/m/Y H:i' : 'd/m/Y à H:i', strtotime($winner_deadline)) ?>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <?php if ($pronostic): ?>
    <div class="alert alert-info text-center mb-4">
      <strong><?= __('your_prediction') ?> :</strong><br>
      <img src="https://flagcdn.com/48x36/<?= $equipes[$pronostic]['flag'] ?>.png" style="border-radius:6px;"> <span class="fw-bold ms-2 team-name"> <?= getTeamName($pronostic, getCurrentLanguage()) ?> </span>
      <!-- <?php if (!$winner_ferme): ?>
        <br><span class="text-muted">Vous pouvez changer votre choix jusqu'à la date limite.
        <?php if ($winner_deadline): ?>
          <br>Date limite : <?= date('d/m/Y à H:i', strtotime($winner_deadline)) ?>
        <?php endif; ?>
        </span>
      <?php endif; ?> -->
    </div>
  <?php endif; ?>

  <div class="row row-cols-2 row-cols-sm-3 row-cols-md-4 row-cols-lg-6 g-3 justify-content-center" id="flagsGrid">
    <?php 
    $current_lang = getCurrentLanguage();
    foreach ($equipes as $code => $equipe): 
    ?>
      <div class="col">
        <div class="flag-card text-center p-2 border rounded bg-white flag-selectable <?= ($pronostic === $code) ? 'selected' : '' ?>" data-team="<?= $code ?>" style="cursor: <?= $winner_ferme ? 'not-allowed' : 'pointer' ?>; opacity: <?= $winner_ferme ? '0.5' : '1' ?>; border:2px solid <?= ($pronostic === $code) ? '#28a745' : '#eee' ?>;">
          <img src="https://flagcdn.com/64x48/<?= $equipe['flag'] ?>.png" style="border-radius:8px; box-shadow:0 2px 8px #0002;">
          <div class="fw-bold mt-2" style="font-size:1.1rem; color:#222;"> <?= getTeamName($code, $current_lang) ?> </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <?php if (!$winner_ferme): ?>
  <div class="text-center mt-4 pt-mobile-60">
    <button id="validateWinnerBtn" class="btn btn-success btn-lg" style="background-color: #990605; border-color: #990605; color: #ffffff; font-size: large;">
      <span id="btnText"><?= __('validate_prediction') ?></span>
      <span id="btnCheck" style="display: none; margin-left: 8px; font-weight: bold; font-size: 1.2em;">✓</span>
    </button>
  </div>
  <?php endif; ?>

</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(function() {
  let selected = "<?= $pronostic ?>";
  const winnerFerme = <?= $winner_ferme ? 'true' : 'false' ?>;
  const initialPronostic = "<?= $pronostic ?>";
  let isValidated = <?= $pronostic ? 'true' : 'false' ?>;

  function setButtonValidated() {
    const btn = $('#validateWinnerBtn');
    // Ajouter la classe pour appliquer le background #d4903c
    btn.addClass('btn-validated');
    $('#btnText').text('<?= __('validated') ?>');
    $('#btnCheck').show();
    isValidated = true;
    // Appliquer aussi le background au drapeau sélectionné
    if (selected) {
      $(`.flag-card[data-team='${selected}']`).css('background-color', '#d4903c');
    }
  }

  function resetButton() {
    const btn = $('#validateWinnerBtn');
    // Retirer la classe pour revenir à l'état initial
    btn.removeClass('btn-validated');
    $('#btnText').text('<?= __('validate_prediction') ?>');
    $('#btnCheck').hide();
    isValidated = false;
    // Réinitialiser le background du drapeau sélectionné
    $('.flag-card').css('background-color', '');
  }

  function updateSelection(team) {
    $('.flag-card').removeClass('selected').css('border-color', '#eee').css('background-color', '');
    $(`.flag-card[data-team='${team}']`).addClass('selected').css('border-color', '#28a745');
    if (!winnerFerme) $('#validateWinnerBtn').show();
    
    // Si on clique sur un drapeau différent du pronostic validé, réinitialiser le bouton
    if (isValidated && team !== initialPronostic) {
      resetButton();
    } else if (isValidated && team === initialPronostic) {
      setButtonValidated();
    }
  }

  $('.flag-card').click(function() {
    if (winnerFerme) return;
    const team = $(this).data('team');
    selected = team;
    updateSelection(team);
  });

  if (selected) {
    updateSelection(selected);
    if (!winnerFerme) {
      $('#validateWinnerBtn').show();
      if (isValidated) {
        setButtonValidated();
      }
    }
  }

  $('#validateWinnerBtn').click(function() {
    if (!selected) return;
    $.post('ajax/save_winner_prediction.php', { team: selected }, function(res) {
      if (res.success) {
        // Mettre à jour l'état avant le reload
        isValidated = true;
        setButtonValidated();
        Swal.fire('<?= __('success') ?>', '<?= __('prediction_saved') ?>', 'success').then(() => location.reload());
      } else {
        Swal.fire('<?= __('error') ?>', res.message || '<?= __('unknown_error') ?>', 'error');
      }
    }, 'json');
  });
});
</script>

<style>
#validateWinnerBtn.btn-validated {
  background-color: #d4903c !important;
  border-color: #d4903c !important;
  color: #ffffff !important;
}
.flag-card.selected {
  box-shadow:0 0 12px 2px #43ea6e99, 0 0 0 2px #b6ffb355;
  outline: 2.5px solid #43ea6e;
  outline-offset: 0px;
  background: linear-gradient(120deg, #eafff0 0%, #b6ffb3 50%, #eaffd0 100%);
  background-size: 200% 200%;
  animation: winner-green-glow 2.5s ease-in-out infinite;
  transform: scale(1.06) rotate(-1deg);
  z-index: 2;
  transition: all 0.35s cubic-bezier(.4,2,.6,1);
}
@keyframes winner-green-glow {
  0% { background-position: 0% 50%; box-shadow:0 0 12px 2px #43ea6e99, 0 0 0 2px #b6ffb355; outline-color: #43ea6e; }
  50% { background-position: 100% 50%; box-shadow:0 0 20px 4px #43ea6ecc, 0 0 0 4px #b6ffb388; outline-color: #43ea6e; }
  100% { background-position: 0% 50%; box-shadow:0 0 12px 2px #43ea6e99, 0 0 0 2px #b6ffb355; outline-color: #43ea6e; }
}
.flag-card {
  min-height: 120px;
  max-height: 120px;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  transition: all 0.25s cubic-bezier(.4,2,.6,1);
  cursor: pointer;
  padding-top: 12px;
  padding-bottom: 12px;
}
.flag-card .fw-bold {
  word-break: break-word;
  white-space: normal;
  font-size: 1.1rem;
  line-height: 1.15;
  margin-top: 8px;
  margin-bottom: 0;
}
.flag-card:hover:not(.selected) {
  border:2.5px solid #388e3c;
  box-shadow:0 0 8px 2px #43ea6e33;
  transform: scale(1.03);
}
</style>

<?php include 'templates/footer.php'; ?> 