<?php
date_default_timezone_set('Africa/Casablanca');

// Inclure le système de langue en premier
require_once 'includes/language.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require 'includes/db.php'; // connexion PDO

if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Vérifier la deadline pour les pronostics de groupes
$groupes_deadline_file = __DIR__.'/includes/groupes_deadline.txt';
$groupes_deadline = '';
$groupes_fermes = false;
if (file_exists($groupes_deadline_file)) {
    $groupes_deadline = trim(file_get_contents($groupes_deadline_file));
    if (!empty($groupes_deadline)) {
        $deadline = str_replace('T', ' ', $groupes_deadline) . ':00';
        if (date('Y-m-d H:i:s') >= $deadline) {
            $groupes_fermes = true;
        }
    }
}

// Groupes et équipes avec codes 3 lettres (aligné admin)
$groupes = [
  'A' => ['MAR' => 'Maroc', 'MAL' => 'Mali', 'ZAM' => 'Zambie', 'COM' => 'Comores'],
  'B' => ['EGY' => 'Égypte', 'RSA' => 'Afrique du Sud', 'ANG' => 'Angola', 'ZIM' => 'Zimbabwe'],
  'C' => ['NGA' => 'Nigeria', 'TUN' => 'Tunisie', 'UGA' => 'Ouganda', 'TAN' => 'Tanzanie'],
  'D' => ['SEN' => 'Sénégal', 'COD' => 'RD Congo', 'BEN' => 'Bénin', 'BOT' => 'Botswana'],
  'E' => ['ALG' => 'Algérie', 'BFA' => 'Burkina Faso', 'EQG' => 'Guinée Équatoriale', 'SUD' => 'Soudan'],
  'F' => ['CIV' => "Côte d'Ivoire", 'CMR' => 'Cameroun', 'GAB' => 'Gabon', 'MOZ' => 'Mozambique'],
];

// Traductions des noms d'équipes en arabe
$equipes_ar = [
  'MAR' => 'المغرب', 'MAL' => 'مالي', 'ZAM' => 'زامبيا', 'COM' => 'جزر القمر',
  'EGY' => 'مصر', 'RSA' => 'جنوب أفريقيا', 'ANG' => 'أنغولا', 'ZIM' => 'زيمبابوي',
  'NGA' => 'نيجيريا', 'TUN' => 'تونس', 'UGA' => 'أوغندا', 'TAN' => 'تنزانيا',
  'SEN' => 'السنغال', 'COD' => 'جمهورية الكونغو الديمقراطية', 'BEN' => 'بنين', 'BOT' => 'بوتسوانا',
  'ALG' => 'الجزائر', 'BFA' => 'بوركينا فاسو', 'EQG' => 'غينيا الاستوائية', 'SUD' => 'السودان',
  'CIV' => 'ساحل العاج', 'CMR' => 'الكاميرون', 'GAB' => 'الغابون', 'MOZ' => 'موزمبيق'
];

$flags = [
  'MAR' => 'ma', 'MAL' => 'ml', 'ZAM' => 'zm', 'COM' => 'km',
  'EGY' => 'eg', 'RSA' => 'za', 'ANG' => 'ao', 'ZIM' => 'zw',
  'NGA' => 'ng', 'TUN' => 'tn', 'UGA' => 'ug', 'TAN' => 'tz',
  'SEN' => 'sn', 'COD' => 'cd', 'BEN' => 'bj', 'BOT' => 'bw',
  'ALG' => 'dz', 'BFA' => 'bf', 'EQG' => 'gq', 'SUD' => 'sd',
  'CIV' => 'ci', 'CMR' => 'cm', 'GAB' => 'ga', 'MOZ' => 'mz'
];

// Pronostics utilisateur (on récupère tous les groupes de l'utilisateur)
$stmt = $mysqli->prepare("SELECT groupe, classement FROM groupe_predictions WHERE user_id = ?");
$stmt->bind_param('i', $user_id);
$stmt->execute();
$result = $stmt->get_result();
$pronostics = [];
while ($row = $result->fetch_assoc()) {
    $pronostics[$row['groupe']] = explode(',', $row['classement']);
}
$stmt->close();

// Résultats réels (si disponibles) + statut final
$result = $mysqli->query("SELECT groupe, classement, is_final FROM groupe_results");
$resultats = [];
$is_final = [];
while ($row = $result->fetch_assoc()) {
    $resultats[$row['groupe']] = explode(',', $row['classement']);
    $is_final[$row['groupe']] = $row['is_final'];
}
$result->close();

// Récupérer les points par groupe pour l'utilisateur
$stmt = $mysqli->prepare('SELECT groupe, points FROM groupe_points WHERE user_id = ?');
$stmt->bind_param('i', $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user_points_groupes = [];
while ($row = $result->fetch_assoc()) {
    $user_points_groupes[$row['groupe']] = $row['points'];
}
$stmt->close();

// Fonction de calcul des points
function calculerPoints($pronostic, $reel) {
    $points = 0;
    foreach ($reel as $i => $code) {
        if (isset($pronostic[$i]) && $pronostic[$i] === $code) $points++;
    }
    return $points;
}

// Fonction pour obtenir le nom de l'équipe selon la langue
function getTeamName($code, $current_lang) {
    global $equipes_ar, $groupes;
    foreach ($groupes as $groupe => $equipes) {
        if (isset($equipes[$code])) {
            if ($current_lang === 'ar') {
                return $equipes_ar[$code] ?? $equipes[$code];
            } else {
                return $equipes[$code];
            }
        }
    }
    return $code;
}

// Fonction pour traduire les lettres de groupes en arabe
function getGroupLetter($groupe, $current_lang) {
    if ($current_lang === 'ar') {
        $group_letters_ar = [
            'A' => 'أ',
            'B' => 'ب', 
            'C' => 'ج',
            'D' => 'د',
            'E' => 'ه',
            'F' => 'و'
        ];
        return $group_letters_ar[$groupe] ?? $groupe;
    }
    return $groupe;
}

include 'templates/header.php';
?>

<style>
/* Styles RTL pour l'arabe */
.lang-ar .groupe-card .card-header {
    text-align: center;
}

.lang-ar .list-group-item {
    flex-direction: row-reverse;
    text-align: right;
    padding: 8px 5px 8px 0px;
}

.lang-ar .position-badge {
    order: 2;
    margin-left: 8px !important;
    margin-right: 0 !important;
}

.lang-ar .team-flag {
    order: 1;
    margin-left: 8px !important;
    margin-right: 8px !important;
}

.lang-ar .team-name {
    order: 0;
    text-align: right;
}

.lang-ar .correct-indicator {
    order: 3;
    margin-left: 0 !important;
    margin-right: 8px !important;
}

.lang-ar .incorrect-indicator {
    order: 3;
    margin-left: 0 !important;
    margin-right: 8px !important;
}

/* Animation pour le drag and drop en RTL */
.lang-ar .ui-state-highlight {
    border: 2px dashed #ffb300;
    background: rgba(255, 179, 0, 0.1);
}

/* Points badge en RTL */
.lang-ar .points-badge {
    margin-left: 8px;
    margin-right: 0;
}

/* Correction du padding des listes en arabe */
.lang-ar ul {
    padding-inline-start: 0px !important;
}

/* Style pour les groupes verrouillés */
.locked-group .list-group-item {
    cursor: default !important;
    user-select: none;
    opacity: 0.9;
}

.locked-group {
    pointer-events: none;
}

.locked-group .list-group-item {
    cursor: not-allowed !important;
}

.incorrect-indicator {
    font-weight: bold;
}

/* Style pour le bouton "Modifier mon classement" */
.btn-modify-ranking {
    background-color: #d4903c !important;
    border-color: #d4903c !important;
    color: #ffffff !important;
}
</style>

<div class="container py-4">
  <h2 class="text-center mb-4" style="color:white; margin-bottom: 5px !important;"><?= __('group_predictions') ?></h2>
  <h6 class="text-center mb-4" style="color:white; margin-bottom: 5px !important;"><?= __('group_instructions_1') ?></h6>
  <h6 class="text-center mb-4" style="color:white; margin-bottom: 16px !important;"><?= __('group_instructions_2') ?></h6>
  <!-- <p class="text-center mb-2" style="color:#eee; font-size:0.95rem; margin-top:-10px;">Heure serveur : <?= date('d/m/Y H:i:s') ?></p> -->
<?php if ($groupes_deadline): ?>
  <p class="text-center mb-4" style="color:#eee; font-size:1rem; margin-top:-8px;"><?= __('group_deadline_text') ?> <?= date(($current_lang === 'ar') ? 'd/m/Y H:i' : 'd/m/Y à H:i', strtotime(str_replace('T', ' ', $groupes_deadline))) ?></p>
<?php endif; ?>
  <hr class="mb-4" style="border-top:2px solid white; width:120px;margin:auto;">

  <?php if ($groupes_fermes): ?>
    <div class="alert alert-warning text-center mb-4">
      <strong><?= __('group_predictions_closed') ?></strong><br>
      <?php if ($groupes_deadline): ?>
        <?= __('deadline') ?> : <?= date(($current_lang === 'ar') ? 'd/m/Y H:i' : 'd/m/Y à H:i', strtotime($groupes_deadline)) ?>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <div class="row justify-content-center">
    <?php foreach ($groupes as $groupe => $equipes): ?>
      <div class="col-md-4 col-lg-4" style="margin-bottom: 30px;">
        <div class="card groupe-card" data-groupe="<?= $groupe ?>" data-is-final="<?= isset($is_final[$groupe]) && $is_final[$groupe] == 1 ? '1' : '0' ?>">
          <div class="card-header text-center">
            <?= __('group') ?> <?= getGroupLetter($groupe, getCurrentLanguage()) ?>
            <?php
              if (isset($user_points_groupes[$groupe])) {
                echo "<span class='points-badge'>{$user_points_groupes[$groupe]} " . __('points') . "</span>";
              }
            ?>
          </div>
          <ul class="list-group sortable-group <?= (isset($is_final[$groupe]) && $is_final[$groupe] == 1) ? 'locked-group' : '' ?>" id="group<?= $groupe ?>">
            <?php
              $ordre = $pronostics[$groupe] ?? array_keys($equipes);
              $pos = 1;
              $current_lang = getCurrentLanguage();
              foreach ($ordre as $code) {
                $nom = getTeamName($code, $current_lang);
                $flag = $flags[$code];
                
                // Vérifier si le pronostic est correct
                $is_correct = false;
                $is_incorrect = false;
                $groupe_is_final = isset($is_final[$groupe]) && $is_final[$groupe] == 1;
                if ($groupe_is_final && isset($resultats[$groupe]) && isset($pronostics[$groupe])) {
                    $real_position = array_search($code, $resultats[$groupe]);
                    $predicted_position = array_search($code, $pronostics[$groupe]);
                    $is_correct = ($real_position !== false && $predicted_position !== false && $real_position === $predicted_position);
                    $is_incorrect = ($real_position !== false && $predicted_position !== false && $real_position !== $predicted_position);
                }
                
                if ($current_lang === 'ar') {
                    echo "<li class='list-group-item d-flex align-items-center justify-content-between' data-team='$code'>";
                    echo "<div class='d-flex align-items-center'>";
                    echo "<span class='badge bg-secondary position-badge' style='min-width:28px;'>$pos</span>";
                    echo "<img src='https://flagcdn.com/24x18/$flag.png' alt='' class='team-flag' style='margin-right:8px;'>";
                    echo "<span class='team-name'>$nom</span>";
                    echo "</div>";
                    if ($is_correct) {
                        echo "<span class='text-success correct-indicator' style='font-size:1.2rem; color: #ffffff !important;'>✓</span>";
                    } elseif ($is_incorrect) {
                        echo "<span class='text-danger incorrect-indicator' style='font-size:1.2rem; color: #ffffff !important;'>✗</span>";
                    }
                    echo "</li>";
                } else {
                    echo "<li class='list-group-item d-flex align-items-center' style='padding: 8px 12px 8px 9px;' data-team='$code'>";
                    echo "<span class='badge bg-secondary position-badge' style='min-width:28px;'>$pos</span>";
                    echo "<img src='https://flagcdn.com/24x18/$flag.png' alt='' class='team-flag' style='margin-right:8px; margin-left:8px;'>";
                    echo "<span class='flex-grow-1 team-name'>$nom</span>";
                    if ($is_correct) {
                        echo "<span class='text-success correct-indicator' style='font-size:1.2rem; color: #ffffff !important;'>✓</span>";
                    } elseif ($is_incorrect) {
                        echo "<span class='text-danger incorrect-indicator' style='font-size:1.2rem; color: #ffffff !important;'>✗</span>";
                    }
                    echo "</li>";
                }
                $pos++;
              }
            ?>
          </ul>
          <?php if (empty($is_final[$groupe]) || $is_final[$groupe] != 1): ?>
            <?php if (!$groupes_fermes): ?>
              <?php $has_prono = isset($pronostics[$groupe]) && count($pronostics[$groupe]) === count($equipes); ?>
              <div class="text-center mt-2">
                <button style="margin-top: 0px !important; <?= $has_prono ? 'background-color: #d4903c; border-color: #d4903c;' : 'background-color: #7f0100;' ?> color: #ffffff;" class="btn btn-success unified-group-btn <?= $has_prono ? 'btn-modify-ranking' : '' ?>" data-groupe="<?= $groupe ?>" data-locked="<?= $has_prono ? '1' : '0' ?>">
                  <?php echo $has_prono ? __('modify_ranking') : __('validate_ranking'); ?>
                </button>
              </div>
            <?php else: ?>
              <button style="margin-top: 0px !important;" class="btn btn-secondary mt-2" disabled><?= __('predictions_closed') ?></button>
            <?php endif; ?>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui-touch-punch/0.2.3/jquery.ui.touch-punch.min.js"></script>
<script>
$(function() {
  // Traductions pour les boutons
  var translations = {
    unlock: '<?= __('unlock_group') ?>',
    lock: '<?= __('lock_group') ?>'
  };
  function updateBadges() {
    $('.sortable-group').each(function() {
      $(this).children('li').each(function(i) {
        $(this).find('.position-badge').text(i+1);
      });
    });
  }
  
  <?php if (!$groupes_fermes): ?>
  // Initialiser le sortable pour tous les groupes, mais désactiver ceux qui sont verrouillés
  $(".sortable-group").each(function() {
    var $group = $(this);
    var $card = $group.closest('.groupe-card');
    var isFinal = $card.data('is-final') == '1';
    
    if (!isFinal) {
      $group.sortable({
        placeholder: "ui-state-highlight",
        update: updateBadges,
        disabled: false
      });
    } else {
      // Groupe final : désactiver complètement le sortable
      $group.sortable({
        disabled: true
      });
      $group.addClass('locked-group');
    }
  });
  
  // Désactiver le sortable pour les groupes verrouillés (qui ont déjà un pronostic validé)
  $(".unified-group-btn").each(function() {
    var $btn = $(this);
    var isLocked = $btn.data('locked') == '1';
    var groupe = $btn.data('groupe');
    var $card = $btn.closest('.groupe-card');
    var isFinal = $card.data('is-final') == '1';
    
    if (isLocked && !isFinal) {
      $("#group" + groupe).sortable('disable');
      $("#group" + groupe).addClass('locked-group');
    }
  });
  <?php endif; ?>
  
  updateBadges();

  // Gestion du bouton unique qui combine déverrouillage et sauvegarde
  $(".unified-group-btn").click(function() {
    var $btn = $(this);
    var groupe = $btn.data("groupe");
    var isLocked = $btn.data('locked') == '1';
    var $groupList = $("#group" + groupe);
    var $card = $btn.closest('.groupe-card');
    var isFinal = $card.data('is-final') == '1';
    
    // Ne pas permettre de modifier les groupes finaux
    if (isFinal) {
      return false;
    }
    
    if (isLocked) {
      // Le groupe est verrouillé : déverrouiller pour permettre la modification
      $groupList.sortable('enable');
      $groupList.removeClass('locked-group');
      $btn.data('locked', '0');
      $btn.text('<?= __('validate_ranking') ?>');
      $btn.removeClass('btn-modify-ranking');
      $btn.css('background-color', '#7f0100');
      $btn.css('border-color', '#7f0100');
    } else {
      // Le groupe est déverrouillé : sauvegarder et verrouiller
      var classement = [];
      $("#group" + groupe + " li").each(function() {
        classement.push($(this).data("team"));
      });
      
      $.post("ajax/save_groupe_pronostic.php", {
        groupe: groupe,
        classement: classement.join(",")
      }, function(response) {
        let res = JSON.parse(response);
        if(res.success) {
          Swal.fire('<?= __('success') ?>', '<?= __('prediction_saved') ?>', 'success');
          
          // Verrouiller le groupe après sauvegarde
          $groupList.sortable('disable');
          $groupList.addClass('locked-group');
          $btn.data('locked', '1');
          $btn.text('<?= __('modify_ranking') ?>');
          $btn.addClass('btn-modify-ranking');
          $btn.css('background-color', '#d4903c');
          $btn.css('border-color', '#d4903c');
        } else {
          Swal.fire('<?= __('error') ?>', res.message || '<?= __('unknown_error') ?>', 'error');
        }
      });
    }
  });
});
</script>

<?php include 'templates/footer.php'; ?> 