<?php
date_default_timezone_set('Etc/GMT-1');
$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');

// Inclure le système de langue en premier
require_once 'includes/language.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if(!isset($_SESSION['user_id'])) {
    header('Location: ' . $base . '/index.php');
    exit;
}
include 'templates/header.php';
?>

<style>
/* Styles RTL pour l'arabe */
.lang-ar .nav-tabs {
    direction: rtl;
}

.lang-ar .nav-pills {
    direction: rtl;
}

.lang-ar .mobile-phase-btns {
    direction: rtl;
}

/* Taille de police réduite pour les boutons mobile-phase-btns en arabe et mobile uniquement */
@media (max-width: 767.98px) {
    .lang-ar .mobile-phase-btns .btn-phase-mobile {
        font-size: 0.85rem !important;
    }
}

.lang-ar .modal-title {
    text-align: right;
}

.lang-ar .modal-footer {
    flex-direction: row-reverse;
}

.lang-ar .modal-footer .me-auto {
    margin-left: 0 !important;
    margin-right: auto !important;
}

/* Correction pour les boutons en RTL */
.lang-ar .btn-phase-mobile {
    direction: rtl;
}

/* Correction pour les tabs en RTL */
.lang-ar .nav-tabs .nav-link {
    text-align: center;
}

.lang-ar .nav-pills .nav-link {
    text-align: center;
}

/* Correction pour le contenu du dashboard en RTL */
.lang-ar .phase-block {
    direction: rtl;
}

.lang-ar .journee-block {
    direction: rtl;
}

/* Correction pour les formulaires en RTL */
.lang-ar .form-control {
    text-align: right;
}

.lang-ar .form-select {
    text-align: right;
}

/* Correction pour les tableaux en RTL */
.lang-ar .table {
    direction: rtl;
}

.lang-ar .table th,
.lang-ar .table td {
    text-align: right;
}

/* Correction pour les matchs en RTL */
.lang-ar .match-row {
    direction: rtl;
}

.lang-ar .team-flag {
    margin-left: 8px !important;
    margin-right: 8px !important;
}

.lang-ar .team-name {
    text-align: right;
}

.lang-ar .score-input {
    text-align: center;
}

/* Correction pour les boutons de validation en RTL */
.lang-ar .btn-validate {
    direction: rtl;
}

/* Correction pour les alertes en RTL */
.lang-ar .alert {
    text-align: right;
}

/* Correction pour les badges de points en RTL */
.lang-ar .points-badge {
    margin-left: 8px !important;
    margin-right: 0 !important;
}

/* Correction pour les titulaires en RTL */
.lang-ar .select-titulaires {
    margin-left: 8px !important;
    margin-right: 0 !important;
}

    /* Correction du padding des listes en arabe */
    .lang-ar ul {
        padding-inline-start: 0px !important;
    }

    /* Style pour le bouton validé */
    .save-prediction.btn-validated {
        background-color: #d4903c !important;
        border-color: #d4903c !important;
        color: #ffffff !important;
    }

/* Correction pour le modal titulaires sur mobile */
@media (max-width: 767.98px) {
    .modal-dialog {
        max-width: 100% !important;
        margin: 0.5rem auto;
    }
    
    #titulairesModal {
        z-index: 1055 !important;
    }
    
    #titulairesModal .modal-dialog {
        margin: 0;
        max-width: 100%;
        height: 100vh;
        display: flex;
        flex-direction: column;
    }
    
    #titulairesModal .modal-content {
        height: 100%;
        border-radius: 0;
        display: flex;
        flex-direction: column;
        margin-top: 0;
        position: relative;
    }
    
    #titulairesModal .modal-header {
        position: relative;
        z-index: 1056 !important;
        flex-shrink: 0;
        padding-top: 20px;
        padding-bottom: 15px;
        padding-left: 20px;
        padding-right: 20px;
        border-bottom: 1px solid rgba(255,255,255,0.2);
        background-color: #23232b;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    #titulairesModal .modal-body {
        flex: 1;
        overflow-y: auto;
        padding: 15px;
    }
    
    #titulairesModal .modal-footer {
        flex-shrink: 0;
        padding: 15px;
        border-top: 1px solid rgba(255,255,255,0.2);
    }
    
    /* S'assurer que le bouton close est visible et accessible */
    #titulairesModal .btn-close {
        position: relative !important;
        z-index: 1057 !important;
        opacity: 1 !important;
        margin: 0 !important;
        padding: 0.5rem !important;
        background-color: rgba(255,255,255,0.15) !important;
        border-radius: 4px;
        width: 32px !important;
        height: 32px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
    }
    
    #titulairesModal .btn-close:hover {
        background-color: rgba(255,255,255,0.25) !important;
    }
    
    /* S'assurer que le backdrop est au-dessus du header */
    .modal-backdrop {
        z-index: 1054 !important;
    }
}
</style>

<h2 class="text-center mb-4" style="color:white;"><?= __('match_predictions') ?></h2>
<h6 class="text-center mb-4" style="color:white; margin-bottom: 5px !important;"><?= __('match_instructions_1') ?></h6>
<h6 class="text-center mb-4" style="color:white; margin-bottom: 5px !important;"><?= __('match_instructions_2') ?></h6>
<?php
// Charger la configuration du délai de clôture des pronostics de matchs
$match_deadline_hours_file = __DIR__.'/includes/match_deadline_hours.txt';
$match_deadline_hours = 1; // Valeur par défaut : 1 heure
if (file_exists($match_deadline_hours_file)) {
    $match_deadline_hours = (int)trim(file_get_contents($match_deadline_hours_file));
    if ($match_deadline_hours <= 0) $match_deadline_hours = 1; // Minimum 1 heure
}

// Créer le message dynamique selon la langue
$current_lang = getCurrentLanguage();
if ($current_lang === 'ar') {
    $deadline_message = "تغلق التوقعات " . $match_deadline_hours . " ساعة قبل كل مباراة.";
} else {
    $deadline_message = "Les pronostics ferment " . $match_deadline_hours . "h avant chaque match.";
}
?>
<p class="text-center mb-4" style="color:#eee; font-size:1rem;"><?= $deadline_message ?></p>
<hr class="mb-4" style="border-top:2px solid white; width:120px;margin:auto;">

<div id="dashboardTabs"></div>
<div id="dashboardContent">
  <!-- Les données du tableau de bord seront chargées ici via AJAX -->
</div>
<script>
const base = "<?= $base ?>";
const currentLang = "<?= getCurrentLanguage() ?>";
const translations = {
    selected: "<?= __('selected') ?>",
    selected_players: "<?= __('selected_players') ?>",
    starters_saved: "<?= __('starters_saved') ?>",
    modify_score: "<?= __('modify_score') ?>",
    modify_your_prediction: "<?= __('modify_your_prediction') ?>",
    score_to_correct: "<?= __('score_to_correct') ?>",
    equality_correction_message: "<?= __('equality_correction_message') ?>",
    penalty_score: "<?= __('penalty_score') ?>",
    validate_new_score: "<?= __('validate_new_score') ?>",
    cancel: "<?= __('cancel') ?>",
    please_enter_valid_scores: "<?= __('please_enter_valid_scores') ?>",
    please_choose_winner: "<?= __('please_choose_winner') ?>",
    prediction_updated: "<?= __('prediction_updated') ?>"
};
$(function() {
  $.get(base + '/ajax/get_dashboard.php', function(data) {
    if(data.success) {
      $('#dashboardContent').html(data.html);
      
      // Récupérer les traductions des phases et journées
      const phasesTitres = data.phases_titres || {};
      const journeesTitres = data.journees_titres || {};
      
      // Génération des tabs dynamiques
      const phases = [];
      $('#dashboardContent .phase-block').each(function() {
        const phase = $(this).data('phase');
        phases.push(phase);
      });
      
      // Ordre officiel souhaité - MÊME LOGIQUE QUE FRANÇAIS
      const phasesOrder = [
        '<?= __('group_phase') ?>',
        '<?= __('round_of_16') ?>',
        '<?= __('quarter_final') ?>',
        '<?= __('semi_final') ?>',
        '<?= __('third_place_match') ?>',
        '<?= __('final') ?>'
      ];
      
      // Trie les phases selon l'ordre officiel, puis ajoute les phases non listées à la fin
      const phasesSorted = phasesOrder.filter(p => phases.includes(p)).concat(phases.filter(p => !phasesOrder.includes(p)));
      
      // Tabs desktop, boutons mobile (journées + phases)
      let isMobile = window.matchMedia('(max-width: 767.98px)').matches;
      
      // Récupère les journées de groupes présentes
      const journeesGroupes = [];
      $('#dashboardContent .phase-block[data-phase="<?= __('group_phase') ?>"] .journee-block').each(function() {
        const journee = $(this).data('journee');
        journeesGroupes.push(journee);
      });
      
      if (!isMobile) {
        let tabsHtml = '<ul class="nav nav-tabs mb-3" id="phaseTabs" role="tablist">';
        phasesSorted.forEach(function(phase, idx) {
          // Utiliser la traduction depuis le serveur ou la phase par défaut
          let phaseTitre = phasesTitres[phase] || phase;
          tabsHtml += '<li class="nav-item" role="presentation">';
          tabsHtml += '<button class="nav-link'+(idx===0?' active':'')+'" id="tab-'+idx+'" data-phase="'+phase+'" type="button" role="tab">'+phaseTitre+'</button>';
          tabsHtml += '</li>';
        });
        tabsHtml += '</ul>';
        $('#dashboardTabs').html(tabsHtml);
      } else {
        // Génère une rangée de boutons pour chaque journée de groupes + chaque phase à élimination directe
        let btnsHtml = '<div class="mobile-phase-btns d-flex flex-wrap gap-2 mb-3">';
        journeesGroupes.forEach(function(j, idx) {
          // Utiliser la traduction depuis le serveur ou la journée par défaut
          let labelTitre = journeesTitres[j] || j;
          btnsHtml += '<button class="btn btn-outline-warning btn-phase-mobile'+(idx===0?' active btn-warning':'')+'" data-journee="'+j+'">'+labelTitre+'</button>';
        });
        phasesSorted.forEach(function(phase, idx) {
          if(phase !== '<?= __('group_phase') ?>') {
            // Utiliser la traduction depuis le serveur ou la phase par défaut
            let label = phasesTitres[phase] || phase;
            // Utiliser la version courte pour la 3e place si c'est défini
            if (phase === '<?= __('third_place_match') ?>') {
              label = phasesTitres['<?= __('third_place_short') ?>'] || phasesTitres[phase] || '<?= __('third_place_short') ?>';
            }
            // Si aucun bouton actif n'a été mis (pas de journées), activer le premier bouton phase
            let isFirst = (journeesGroupes.length === 0 && idx === 0);
            btnsHtml += '<button class="btn btn-outline-warning btn-phase-mobile'+(isFirst?' active btn-warning':'')+'" data-phase="'+phase+'">'+label+'</button>';
          }
        });
        btnsHtml += '</div>';
        $('#dashboardTabs').html(btnsHtml);
        
        // S'assurer que showMobileBtn est défini avant d'appeler
        setTimeout(function() {
          let $firstActive = $('.btn-phase-mobile.active.btn-warning');
          if ($firstActive.length) {
            if ($firstActive.data('journee')) {
              showMobileBtn('journee:' + $firstActive.data('journee'));
            } else if ($firstActive.data('phase')) {
              showMobileBtn('phase:' + $firstActive.data('phase'));
            }
          }
        }, 0);
      }
      
      // Affichage dynamique mobile : aucun match au départ, puis journée/phase au clic
      function showMobileBtn(target) {
        $('.phase-block, .journee-block').hide();
        if(target.startsWith('journee:')) {
          $('.phase-block[data-phase="<?= __('group_phase') ?>"]').show();
          $('.phase-block[data-phase="<?= __('group_phase') ?>"] .journee-block').hide();
          $('.phase-block[data-phase="<?= __('group_phase') ?>"] .journee-block[data-journee="'+target.substring(8)+'"').show();
        } else if(target.startsWith('phase:')) {
          let phase = target.substring(6);
          $('.phase-block[data-phase="'+phase+'"').show();
        }
      }
      
      if (!isMobile) {
        $('#phaseTabs .nav-link').click(function(){
          $('#phaseTabs .nav-link').removeClass('active');
          $(this).addClass('active');
          $('#dashboardContent .nav-pills').remove();
          $('#dashboardContent .form-select').remove();
          showPhase($(this).data('phase'));
        });
        showPhase(phasesSorted[0]);
      } else {
        // Par défaut, aucun match affiché
        $('.phase-block, .journee-block').hide();
        // Clic sur bouton journée/phase
        $(document).on('click', '.btn-phase-mobile', function(){
          $('.btn-phase-mobile').removeClass('active btn-warning').addClass('btn-outline-warning');
          $(this).removeClass('btn-outline-warning').addClass('active btn-warning');
          if($(this).data('journee')) {
            showMobileBtn('journee:'+$(this).data('journee'));
          } else if($(this).data('phase')) {
            showMobileBtn('phase:'+$(this).data('phase'));
          }
        });
      }
    } else {
      showToast(data.message, 'danger');
    }
  }, 'json').fail(function(xhr, status, error) {
    console.error('Erreur AJAX:', status, error);
  });
});

// Fonction d'affichage desktop par phase - MÊME LOGIQUE QUE FRANÇAIS
function showPhase(phase) {
  $('.phase-block, .journee-block').hide();
  if(phase) {
    $('.phase-block[data-phase="'+phase+'"').show();
    // Si phase de groupes, affiche les tabs journées et la première journée par défaut
    if(phase==="<?= __('group_phase') ?>") {
      const journees = [];
      $('.phase-block[data-phase="<?= __('group_phase') ?>"] .journee-block').each(function(){
        journees.push($(this).data('journee'));
      });
      if(journees.length) {
        // Génère les sous-tabs journées si pas déjà présents
        if($('#journeeTabsDesktop').length === 0) {
          let sousTabs = '<ul class="nav nav-pills mb-2" id="journeeTabsDesktop">';
          journees.forEach(function(j, idx){
            sousTabs += '<li class="nav-item">';
            sousTabs += '<button class="nav-link'+(idx===0?' active':'')+'" data-journee="'+j+'">'+j+'</button>';
            sousTabs += '</li>';
          });
          sousTabs += '</ul>';
          $('.phase-block[data-phase="<?= __('group_phase') ?>"]').prepend(sousTabs);
        }
        $('.phase-block[data-phase="<?= __('group_phase') ?>"] .journee-block').hide();
        $('.phase-block[data-phase="<?= __('group_phase') ?>"] .journee-block[data-journee="'+journees[0]+'"').show();
        // Handler clic sur sous-tab journée
        $('#journeeTabsDesktop .nav-link').off('click').on('click', function(){
          $('#journeeTabsDesktop .nav-link').removeClass('active');
          $(this).addClass('active');
          let j = $(this).data('journee');
          $('.phase-block[data-phase="<?= __('group_phase') ?>"] .journee-block').hide();
          $('.phase-block[data-phase="<?= __('group_phase') ?>"] .journee-block[data-journee="'+j+'"').show();
        });
      } else {
        $('#journeeTabsDesktop').remove();
      }
    } else {
      $('#journeeTabsDesktop').remove();
    }
  }
}
</script>
<!-- Modal Sélection 11 titulaires -->
<div class="modal fade" id="titulairesModal" tabindex="-1" aria-labelledby="titulairesModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content bg-dark text-white">
      <div class="modal-header">
        <h5 class="modal-title" id="titulairesModalLabel"><?= __('select_morocco_starters') ?></h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="<?= __('close') ?>"></button>
      </div>
      <div class="modal-body" id="titulairesModalBody"></div>
      <div class="modal-footer">
        <span id="titulairesCount" class="me-auto">0/11 <?= __('selected') ?></span>
        <button type="button" class="btn btn-success" id="saveTitulairesBtn" disabled><?= __('save') ?></button>
      </div>
    </div>
  </div>
</div>
<?php include 'templates/footer.php'; ?>
