<?php
// Contenu du quiz pour chaque phase

// Variables nécessaires
$start_time_db = null;
$locked = 0;
$phase_name = $selected_phase ?? 'Quiz';

// Récupérer les informations du quiz depuis la base de données
$table_check = $mysqli->query("SHOW TABLES LIKE 'quizz_results_phases'");
if ($table_check && $table_check->num_rows > 0) {
    $stmt_phase = $mysqli->prepare('SELECT score, locked, start_time FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
    if ($stmt_phase) {
        $stmt_phase->bind_param('is', $user_id, $selected_phase);
        $stmt_phase->execute();
        $stmt_phase->bind_result($score_phase, $locked_phase, $start_time_phase);
        $stmt_phase->fetch();
        $stmt_phase->close();
        
        $start_time_db = $start_time_phase;
        $locked = $locked_phase;
    }
}

// Si le quiz n'a pas encore commencé, afficher l'écran d'attente
if (!isset($_SESSION['quizz_started']) || !isset($_SESSION['quizz_theme_idx']) || !isset($_SESSION['quizz_q_idx']) || !$start_time_db) {
    ?>
    <style>
    .quiz-phase-info .emoji {
        font-size: 2.7rem;
        margin-bottom: 12px;
        display: block;
        text-align: center;
    }
    .quiz-phase-info h2 {
        color: #ffb300;
        font-size: 2.2rem;
        font-weight: 900;
        margin-bottom: 18px;
        letter-spacing: 1px;
        text-shadow: 0 2px 8px #ffb30022;
        text-align: center;
    }
    .quiz-phase-info .wait-message {
        color: #fff;
        font-size: 1.18rem;
        font-weight: 600;
        margin-bottom: 18px;
        background: #ffb30022;
        border-radius: 12px;
        padding: 14px 10px 10px 10px;
        box-shadow: 0 2px 8px #ffb30022;
        line-height: 1.5;
        text-shadow: 0 2px 8px #fff7;
        text-align: center;
    }
    .quiz-phase-info .wait-warning {
        color: #ffb300;
        font-weight: 800;
        font-size: 1.08rem;
        margin-bottom: 10px;
        margin-top: 8px;
        letter-spacing: 1px;
        text-shadow: 0 2px 8px #fff7;
        text-align: center;
    }
    .quiz-phase-info .quizz-btn {
        background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
        color: #23232b;
        border: none;
        border-radius: 10px;
        font-weight: 800;
        font-size: 1.18rem;
        padding: 14px 38px;
        transition: background 0.18s, color 0.18s, transform 0.12s;
        display: block;
        margin: 32px auto 0 auto;
        box-shadow: 0 2px 12px #ffb30033;
        letter-spacing: 1px;
        cursor: pointer;
    }
    .quiz-phase-info .quizz-btn:hover {
        background: #fffbe6;
        color: #ffb300;
        transform: scale(1.05);
    }
    </style>
    
    <div class="quiz-phase-info">
        <span class="emoji">⏳</span>
        <h2><?= __('quiz_ready') ?></h2>
        <div class="wait-message">
            <?= __('quiz_waiting_message') ?>
        </div>
        <div class="wait-warning">
            ⚠️ <?= __('quiz_warning') ?>
        </div>
        <form method="post">
            <input type="hidden" name="phase" value="<?= $selected_phase ?>">
            <button type="submit" name="start_quizz" class="quizz-btn">
                <?= __('start_quiz') ?>
            </button>
        </form>
    </div>
    <?php
    return;
}

if ($start_time_db) {
    // La date en base est en UTC, on la lit en UTC
    $dt = new DateTime($start_time_db, new DateTimeZone('UTC'));
    $start_timestamp = $dt->getTimestamp();
    $time_left = $time_limit - (time() - $start_timestamp);
} else {
    $time_left = $time_limit;
}
if ($time_left < 0) $time_left = 0;

// Si le temps est écoulé, terminer le quizz
if ($time_left <= 0 && $locked != 1) {
    // Calculer le score partiel
    $score = 0;
    if (isset($_SESSION['quizz_answers'])) {
        foreach ($_SESSION['quizz_answers'] as $qid => $user_answer) {
            $question = getTranslatedQuestion($mysqli, $qid, $current_lang);
            if ($user_answer === $question['answer']) $score += 2;
        }
    }
    // Verrouiller le quizz
    $stmt = $mysqli->prepare('INSERT INTO quizz_results_phases (user_id, phase, score, completed_at, locked) VALUES (?, ?, ?, UTC_TIMESTAMP(), 1) ON DUPLICATE KEY UPDATE score = VALUES(score), completed_at = VALUES(completed_at), locked = 1');
    $stmt->bind_param('isi', $user_id, $selected_phase, $score);
    $stmt->execute();
    $stmt->close();
    unset($_SESSION['quizz_started'], $_SESSION['quizz_start_time'], $_SESSION['quizz_progress'], $_SESSION['quizz_answers'], $_SESSION['quizz_theme_idx'], $_SESSION['quizz_q_idx'], $_SESSION['quizz_show_answer']);
    
    // Afficher l'écran de fin directement au lieu de rediriger
    ?>
    <style>
    .quiz-phase-info {
        background: #29293a;
        border-radius: 14px;
        padding: 25px;
        margin-bottom: 20px;
        border: 2px solid #ffb30044;
        text-align: center;
    }
    .quiz-phase-info h3 {
        color: #ffb300;
        font-size: 1.6rem;
        font-weight: 900;
        margin-bottom: 15px;
    }
    .quiz-phase-info p {
        color: #fff;
        font-size: 1.1rem;
        margin-bottom: 15px;
    }
    .quiz-score-display {
        background: #23232b;
        border-radius: 10px;
        padding: 15px;
        margin: 15px 0;
        border: 2px solid #ffb30044;
    }
    .score-value {
        color: #ffb300;
        font-size: 2rem;
        font-weight: 900;
        display: block;
        margin-bottom: 5px;
    }
    .score-label {
        color: #fff;
        font-size: 0.9rem;
    }
    .btn {
        background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
        color: #23232b;
        border: none;
        border-radius: 8px;
        font-weight: 700;
        font-size: 1rem;
        padding: 12px 24px;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
    }
    .btn:hover {
        background: #fffbe6;
        transform: scale(1.05);
    }
    </style>
    
    <div class="quiz-phase-info">
        <h3><?= (isset($phase_name) ? htmlspecialchars($phase_name) : 'Quiz') ?></h3>
        <p><?= ($current_lang === 'ar') ? 'انتهى الوقت' : 'Temps écoulé' ?></p>
        <div class="quiz-score-display">
            <span class="score-value"><?= $score ?>/30</span>
            <span class="score-label"><?= __('points_label') ?></span>
        </div>
        <p><a href="quizz.php" class="btn"><?= ($current_lang === 'ar') ? 'العودة إلى الاختبارات' : 'Retour aux quiz' ?></a></p>
    </div>
    <?php
    return;
}


// Récupérer la question actuelle
$current_theme = $themes[$_SESSION['quizz_theme_idx']];
$current_question_idx = $_SESSION['quizz_q_idx'];

// Récupérer les questions pour cette phase et ce thème
$stmt = $mysqli->prepare("SELECT id, question, answer, option1, option2, option3, option4 FROM quizz_questions WHERE theme = ? AND phase = ? ORDER BY RAND() LIMIT 5");
$stmt->bind_param('ss', $current_theme, $selected_phase);
$stmt->execute();
$result = $stmt->get_result();
$questions = [];
while ($q = $result->fetch_assoc()) {
    $questions[] = $q;
}
$stmt->close();

if (empty($questions)) {
    echo '<div class="quiz-phase-info">';
    echo '<h3>' . htmlspecialchars($phase_name) . '</h3>';
    echo '<p>' . (($current_lang === 'ar') ? 'لا توجد أسئلة لهذا الموضوع في هذه المرحلة' : 'Aucune question disponible pour ce thème dans cette phase') . '</p>';
    echo '</div>';
    return;
}

// Vérifier qu'il y a des questions
if (empty($questions)) {
    echo '<div class="quiz-phase-info">';
    echo '<h3>' . (isset($phase_name) ? htmlspecialchars($phase_name) : 'Quiz') . '</h3>';
    echo '<p>' . (($current_lang === 'ar') ? 'لا توجد أسئلة لهذا الموضوع في هذه المرحلة' : 'Aucune question disponible pour ce thème dans cette phase') . '</p>';
    echo '<p><small>' . (($current_lang === 'ar') ? 'يرجى إضافة أسئلة في لوحة الإدارة' : 'Veuillez ajouter des questions via l\'interface admin') . '</small></p>';
    echo '</div>';
    return;
}

// Vérifier que l'index de la question est valide
if (!isset($questions[$current_question_idx])) {
    echo '<div class="quiz-phase-info">';
    echo '<h3>' . (isset($phase_name) ? htmlspecialchars($phase_name) : 'Quiz') . '</h3>';
    echo '<p>' . (($current_lang === 'ar') ? 'خطأ في تحميل السؤال' : 'Erreur lors du chargement de la question') . '</p>';
    echo '</div>';
    return;
}

$current_question = $questions[$current_question_idx];
$question_id = $current_question['id'];

// Calculer la progression
$total_questions = count($themes) * 5;
$questions_done = ($_SESSION['quizz_theme_idx'] * 5) + $_SESSION['quizz_q_idx'];
$progress_percent = ($questions_done / $total_questions) * 100;
?>

<style>
.quizz-container {
    background: linear-gradient(135deg, #23232b 80%, #ffb30022 100%);
    border-radius: 18px;
    box-shadow: 0 4px 24px #0005;
    padding: 30px;
    margin: 20px 0;
    border: 2px solid #ffb30044;
}

.quizz-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 30px;
    flex-wrap: wrap;
    gap: 15px;
}

.quizz-progress {
    background: #29293a;
    border-radius: 10px;
    padding: 15px;
    border: 2px solid #ffb30044;
    flex: 1;
    min-width: 200px;
}

.progress-bar {
    background: #ffb300;
    height: 8px;
    border-radius: 4px;
    transition: width 0.3s ease;
    margin-bottom: 10px;
}

.progress-text {
    color: #fff;
    font-weight: 600;
    font-size: 0.9rem;
}

.quizz-timer {
    background: #29293a;
    border-radius: 10px;
    padding: 15px;
    border: 2px solid #ffb30044;
    text-align: center;
    min-width: 120px;
}

.timer-display {
    color: #ffb300;
    font-size: 1.5rem;
    font-weight: 900;
    font-family: 'Courier New', monospace;
}

.quizz-title {
    color: #ffb300;
    font-size: 1.8rem;
    font-weight: 900;
    margin-bottom: 20px;
    text-align: center;
    text-shadow: 0 2px 8px #ffb30022;
}

.quizz-question {
    background: #29293a;
    border-radius: 14px;
    padding: 25px;
    margin-bottom: 25px;
    border: 2px solid #ffb30044;
}

.quizz-question h3 {
    color: #fff;
    font-size: 1.3rem;
    font-weight: 700;
    margin-bottom: 20px;
    line-height: 1.5;
}

.quizz-choices {
    display: grid;
    gap: 12px;
}

.quizz-choice {
    background: #23232b;
    border: 2px solid #ffb30044;
    border-radius: 10px;
    padding: 15px;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
}

.quizz-choice:hover {
    background: #ffb30022;
    border-color: #ffb300;
    transform: translateY(-2px);
}

.quizz-choice input[type="radio"] {
    display: none;
}

.quizz-choice-label {
    color: #fff;
    font-weight: 600;
    cursor: pointer;
    display: block;
    padding-left: 10px;
}

.quizz-choice input[type="radio"]:checked + .quizz-choice-label {
    color: #ffb300;
}

.quizz-choice:has(input[type="radio"]:checked) {
    background: #ffb30022;
    border-color: #ffb300;
}

.quizz-btn {
    background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
    color: #23232b;
    border: none;
    border-radius: 10px;
    font-weight: 800;
    font-size: 1.1rem;
    padding: 15px 30px;
    transition: all 0.3s ease;
    cursor: pointer;
    display: block;
    margin: 20px auto 0 auto;
    box-shadow: 0 4px 15px #ffb30033;
}

.quizz-btn:hover {
    background: #fffbe6;
    transform: scale(1.05);
}

.quizz-btn:disabled {
    background: #666;
    cursor: not-allowed;
    transform: none;
}

@media (max-width: 768px) {
    .quizz-header {
        flex-direction: column;
        align-items: stretch;
    }
    
    .quizz-progress,
    .quizz-timer {
        min-width: auto;
    }
    
    .quizz-container {
        padding: 20px;
    }
    
    .quizz-title {
        font-size: 1.5rem;
    }
}
</style>

<div class="quizz-container">
    <div class="quizz-header">
        <div class="quizz-progress">
            <div class="progress-bar" style="width: <?= $progress_percent ?>%"></div>
            <div class="progress-text">
                <?= $questions_done ?>/<?= $total_questions ?> <?= __('questions') ?>
            </div>
        </div>
        
        <div class="quizz-timer">
            <div class="timer-display" id="timer"><?= gmdate('i:s', $time_left) ?></div>
            <div style="color: #fff; font-size: 0.8rem; margin-top: 5px;"><?= __('time_left') ?></div>
        </div>
    </div>
    
    <div class="quizz-title">
        <?= htmlspecialchars($current_theme) ?> - <?= __('question') ?> <?= $current_question_idx + 1 ?>/5
    </div>
    
    <form method="post" id="quizForm">
        <input type="hidden" name="question_id" value="<?= $question_id ?>">
        <input type="hidden" name="theme" value="<?= htmlspecialchars($current_theme) ?>">
        
        <div class="quizz-question">
            <h3><?= htmlspecialchars($current_question['question']) ?></h3>
            
            <div class="quizz-choices">
                <?php
                $options = [
                    'A' => $current_question['option1'],
                    'B' => $current_question['option2'],
                    'C' => $current_question['option3'],
                    'D' => $current_question['option4']
                ];
                
                foreach ($options as $key => $option):
                ?>
                <div class="quizz-choice">
                    <input type="radio" name="answer" value="<?= $key ?>" id="choice_<?= $key ?>" required>
                    <label for="choice_<?= $key ?>" class="quizz-choice-label">
                        <strong><?= $key ?>.</strong> <?= htmlspecialchars($option) ?>
                    </label>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <button type="submit" name="submit_answer" class="quizz-btn">
            <?= __('next_question') ?>
        </button>
    </form>
</div>

<script>
// Timer countdown
let timeLeft = <?= $time_left ?>;
const timerElement = document.getElementById('timer');

function updateTimer() {
    const minutes = Math.floor(timeLeft / 60);
    const seconds = timeLeft % 60;
    timerElement.textContent = minutes.toString().padStart(2, '0') + ':' + seconds.toString().padStart(2, '0');
    
    if (timeLeft <= 0) {
        document.getElementById('quizForm').submit();
        return;
    }
    
    timeLeft--;
}

updateTimer();
setInterval(updateTimer, 1000);

// Auto-submit when time runs out
setTimeout(function() {
    if (timeLeft <= 0) {
        document.getElementById('quizForm').submit();
    }
}, timeLeft * 1000);
</script>
