<?php
// Redirection vers le nouveau système de quiz par phase
header('Location: quizz_new_phases.php');
exit;

// Définir les variables nécessaires
$current_lang = getCurrentLanguage();

// Phases de quizz
$phases = [
  'Phase de groupes' => ($current_lang === 'ar') ? __('quiz_phase_groups') : __('quiz_phase_groups'),
  '8e de finale' => ($current_lang === 'ar') ? __('quiz_phase_round16') : __('quiz_phase_round16'),
  'Quart de finale' => ($current_lang === 'ar') ? __('quiz_phase_quarter') : __('quiz_phase_quarter'),
  'Demi-finale' => ($current_lang === 'ar') ? __('quiz_phase_semi') : __('quiz_phase_semi')
];

// Thèmes de quizz
$themes = [
  'can2025' => ($current_lang === 'ar') ? "كأس أمم إفريقيا 2025" : "CAN 2025",
  'lions' => ($current_lang === 'ar') ? "أسود الأطلس" : "Lions de l'Atlas",
  'societe' => ($current_lang === 'ar') ? "مجتمع BMCI البنكي" : "Société BMCI Banque"
];

// Définir les clés des phases et thèmes
$phase_keys = array_keys($phases);
$theme_keys = array_keys($themes);

// Mettre à jour la table selon la langue actuelle (sans réinitialiser le quiz)
$expected_table = ($current_lang === 'ar') ? 'quizz_questions_ar' : 'quizz_questions';
$_SESSION['quizz_table'] = $expected_table;

// S'assurer que les variables de progression sont initialisées
if (!isset($_SESSION['quizz_phase_idx'])) {
    $_SESSION['quizz_phase_idx'] = 0;
}
if (!isset($_SESSION['quizz_theme_idx'])) {
    $_SESSION['quizz_theme_idx'] = 0;
}
if (!isset($_SESSION['quizz_q_idx'])) {
    $_SESSION['quizz_q_idx'] = 0;
}
if (!isset($_SESSION['quizz_show_answer'])) {
    $_SESSION['quizz_show_answer'] = false;
}

// Inclure la base de données AVANT le header
require_once 'includes/db.php';

// Fonction pour récupérer une question traduite
function getTranslatedQuestion($mysqli, $question_id, $current_lang) {
    $table_name = ($current_lang === 'ar') ? 'quizz_questions_ar' : 'quizz_questions';
    $stmt = $mysqli->prepare("SELECT * FROM {$table_name} WHERE id = ?");
    $stmt->bind_param('i', $question_id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    return $result;
}

$user_id = $_SESSION['user_id'];
$time_limit = 300; // 5 minutes

// Récupérer l'état du quizz pour l'utilisateur et la phase sélectionnée
$selected_phase = $_SESSION['selected_phase'] ?? 'Phase de groupes';

// Vérifier si la table quizz_results_phases existe, sinon utiliser l'ancienne table
$table_check = $mysqli->query("SHOW TABLES LIKE 'quizz_results_phases'");
if ($table_check && $table_check->num_rows > 0) {
    $stmt = $mysqli->prepare('SELECT score, locked, start_time FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
    if ($stmt) {
        $stmt->bind_param('is', $user_id, $selected_phase);
        $stmt->execute();
        $stmt->bind_result($score_locked, $locked, $start_time_db);
        $stmt->fetch();
        $stmt->close();
    } else {
        $score_locked = 0;
        $locked = 0;
        $start_time_db = null;
    }
} else {
    // Utiliser l'ancienne table si la nouvelle n'existe pas
    $stmt = $mysqli->prepare('SELECT score, locked, start_time FROM quizz_results WHERE user_id = ?');
    if ($stmt) {
        $stmt->bind_param('i', $user_id);
        $stmt->execute();
        $stmt->bind_result($score_locked, $locked, $start_time_db);
        $stmt->fetch();
        $stmt->close();
    } else {
        $score_locked = 0;
        $locked = 0;
        $start_time_db = null;
    }
}

// Démarrage du quizz pour une phase spécifique
if (isset($_POST['start_quizz'])) {
    $phase_to_start = $_POST['phase'] ?? $selected_phase;
    
    // Vérifier si la table quizz_results_phases existe
    $table_check = $mysqli->query("SHOW TABLES LIKE 'quizz_results_phases'");
    if ($table_check && $table_check->num_rows > 0) {
        $stmt = $mysqli->prepare('INSERT INTO quizz_results_phases (user_id, phase, start_time) VALUES (?, ?, UTC_TIMESTAMP()) ON DUPLICATE KEY UPDATE start_time = IFNULL(start_time, UTC_TIMESTAMP())');
        if ($stmt) {
            $stmt->bind_param('is', $user_id, $phase_to_start);
            $stmt->execute();
            $stmt->close();
        }
    }
    
    // Initialiser les variables de session pour cette phase
    $_SESSION['quizz_started_' . $phase_to_start] = true;
    $_SESSION['quizz_theme_idx_' . $phase_to_start] = 0;
    $_SESSION['quizz_q_idx_' . $phase_to_start] = 0;
    unset($_SESSION['quizz_progress_' . $phase_to_start], $_SESSION['quizz_answers_' . $phase_to_start], $_SESSION['quizz_show_answer_' . $phase_to_start]);
    
    header('Location: quizz.php');
    exit;
}

// Gestion de la sélection de phase
if (isset($_POST['select_phase']) || isset($_GET['phase'])) {
    $phase_to_select = $_POST['phase'] ?? $_GET['phase'];
    $_SESSION['selected_phase'] = $phase_to_select;
    // Réinitialiser tous les quiz pour toutes les phases
    unset($_SESSION['quizz_started'], $_SESSION['quizz_progress'], $_SESSION['quizz_answers'], $_SESSION['quizz_theme_idx'], $_SESSION['quizz_q_idx'], $_SESSION['quizz_show_answer']);
    header('Location: quizz.php');
    exit;
}

// Gestion de la soumission d'une réponse pour une phase spécifique
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['start_quizz']) && !isset($_POST['select_phase'])) {
  if (isset($_POST['submit_answer']) && isset($_POST['phase'])) {
    $phase_key = $_POST['phase'];
    $question_id = $_POST['question_id'];
    $user_answer = $_POST['answer'];
    
    // Sauvegarder la réponse pour cette phase
    if (!isset($_SESSION['quizz_answers_' . $phase_key])) {
      $_SESSION['quizz_answers_' . $phase_key] = [];
    }
    $_SESSION['quizz_answers_' . $phase_key][$question_id] = $user_answer;
    
    // Progression pour cette phase
    $current_theme_idx = $_SESSION['quizz_theme_idx_' . $phase_key] ?? 0;
    $current_question_idx = $_SESSION['quizz_q_idx_' . $phase_key] ?? 0;
    
    // Vérifier si on est à la dernière question (question 20)
    if ($current_theme_idx == count($themes) - 1 && $current_question_idx == 4) {
      // Dernière question atteinte, terminer le quiz pour cette phase
      $score = 0;
      foreach ($_SESSION['quizz_answers_' . $phase_key] as $qid => $answer) {
        $question = getTranslatedQuestion($mysqli, $qid, $current_lang);
        if ($answer === $question['answer']) $score += 10;
      }
      
      // Sauvegarder le score pour cette phase
      $stmt = $mysqli->prepare('INSERT INTO quizz_results_phases (user_id, phase, score, completed_at, locked) VALUES (?, ?, ?, UTC_TIMESTAMP(), 1) ON DUPLICATE KEY UPDATE score = VALUES(score), completed_at = VALUES(completed_at), locked = 1');
      if ($stmt) {
        $stmt->bind_param('isi', $user_id, $phase_key, $score);
        $stmt->execute();
        $stmt->close();
      }
      
      unset($_SESSION['quizz_started_' . $phase_key], $_SESSION['quizz_theme_idx_' . $phase_key], $_SESSION['quizz_q_idx_' . $phase_key], $_SESSION['quizz_answers_' . $phase_key]);
      header('Location: quizz.php');
      exit;
    }
    
    // Progression normale pour cette phase
    if ($current_question_idx < 4) {
      $_SESSION['quizz_q_idx_' . $phase_key] = $current_question_idx + 1;
    } else {
      $_SESSION['quizz_q_idx_' . $phase_key] = 0;
      $_SESSION['quizz_theme_idx_' . $phase_key] = $current_theme_idx + 1;
    }
    
    header('Location: quizz.php');
    exit;
  }
}

// Debug: Vérifier que la progression ne change pas lors du changement de langue
if (isset($_SESSION['quizz_theme_idx']) && isset($_SESSION['quizz_q_idx'])) {
    // S'assurer que les valeurs restent cohérentes
    $current_theme_idx = $_SESSION['quizz_theme_idx'];
    $current_q_idx = $_SESSION['quizz_q_idx'];
    
    // Vérifier que les valeurs sont valides
    if ($current_theme_idx >= count($themes)) {
        $_SESSION['quizz_theme_idx'] = count($themes) - 1;
    }
    if ($current_q_idx >= 5) {
        $_SESSION['quizz_q_idx'] = 4;
    }
}

// Vérification de sécurité : si on dépasse les limites, terminer le quiz
if (isset($_SESSION['quizz_theme_idx']) && $_SESSION['quizz_theme_idx'] >= count($themes)) {
  // Cas de sécurité : si on dépasse les limites, terminer le quiz
  $score = 0;
  if (isset($_SESSION['quizz_answers'])) {
    foreach ($_SESSION['quizz_answers'] as $qid => $user_answer) {
      $question = getTranslatedQuestion($mysqli, $qid, $current_lang);
      if ($user_answer === $question['answer']) $score += 10;
    }
  }
  $stmt = $mysqli->prepare('INSERT INTO quizz_results_phases (user_id, phase, score, completed_at, locked) VALUES (?, ?, ?, UTC_TIMESTAMP(), 1) ON DUPLICATE KEY UPDATE score = VALUES(score), completed_at = VALUES(completed_at), locked = 1');
  $stmt->bind_param('isi', $user_id, $selected_phase, $score);
  $stmt->execute();
  $stmt->close();
  unset($_SESSION['quizz_started'], $_SESSION['quizz_start_time'], $_SESSION['quizz_progress'], $_SESSION['quizz_answers'], $_SESSION['quizz_theme_idx'], $_SESSION['quizz_q_idx'], $_SESSION['quizz_show_answer']);
  header('Location: quizz.php');
  exit;
}

include 'templates/header.php';
?>

<style>
.quiz-tabs {
    max-width: 800px;
    margin: 20px auto;
    background: linear-gradient(135deg, #23232b 80%, #ffb30022 100%);
    border-radius: 18px;
    box-shadow: 0 4px 24px #0005;
    padding: 20px;
}

.quiz-tabs .nav-tabs {
    border-bottom: 2px solid #ffb30044;
    margin-bottom: 20px;
}

.quiz-tabs .nav-tabs .nav-link {
    color: #fff;
    border: none;
    background: transparent;
    border-radius: 10px 10px 0 0;
    margin-right: 5px;
    padding: 12px 20px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.quiz-tabs .nav-tabs .nav-link:hover {
    background: #ffb30022;
    color: #ffb300;
}

.quiz-tabs .nav-tabs .nav-link.active {
    background: #ffb300;
    color: #23232b;
    font-weight: 800;
}

.quiz-tabs .tab-content {
    background: transparent;
    border: none;
    padding: 0;
}

.quiz-phase-info {
    background: #29293a;
    border-radius: 14px;
    padding: 15px;
    margin-bottom: 20px;
    border: 2px solid #ffb30044;
    text-align: center;
}

.quiz-phase-info h3 {
    color: #ffb300;
    font-size: 1.4rem;
    font-weight: 900;
    margin-bottom: 10px;
}

.quiz-phase-info p {
    color: #fff;
    font-size: 1rem;
    margin: 0;
}

.quiz-stats {
    display: flex;
    justify-content: space-around;
    margin-bottom: 20px;
    flex-wrap: wrap;
    gap: 15px;
}

.quiz-stat {
    background: #29293a;
    border-radius: 10px;
    padding: 10px 15px;
    text-align: center;
    border: 2px solid #ffb30044;
    min-width: 120px;
}

.quiz-stat .stat-label {
    color: #ffb300;
    font-size: 0.9rem;
    font-weight: 600;
    margin-bottom: 5px;
}

.quiz-stat .stat-value {
    color: #fff;
    font-size: 1.2rem;
    font-weight: 800;
}

.quiz-score-display {
    background: #29293a;
    border-radius: 10px;
    padding: 15px;
    margin-top: 15px;
    text-align: center;
    border: 2px solid #ffb30044;
}

.quiz-score-display .score-value {
    color: #ffb300;
    font-size: 2rem;
    font-weight: 900;
    display: block;
    margin-bottom: 5px;
}

.quiz-score-display .score-label {
    color: #fff;
    font-size: 1rem;
    font-weight: 600;
}

.btn {
    padding: 12px 24px;
    border-radius: 8px;
    font-weight: 600;
    text-decoration: none;
    display: inline-block;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
}

.btn-success {
    background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
    color: #23232b;
}

.btn-success:hover {
    background: #fffbe6;
    color: #ffb300;
    transform: scale(1.05);
}

.btn-warning {
    background: linear-gradient(90deg, #ff9800 60%, #ffc107 100%);
    color: #23232b;
}

.btn-warning:hover {
    background: #ffc107;
    color: #ff9800;
    transform: scale(1.05);
}

.btn-lg {
    padding: 16px 32px;
    font-size: 1.2rem;
}

@media (max-width: 600px) {
    .quiz-tabs {
        margin: 10px;
        padding: 15px;
    }
    
    .quiz-tabs .nav-tabs .nav-link {
        padding: 8px 12px;
        font-size: 0.9rem;
    }
    
    .quiz-stats {
        flex-direction: column;
        align-items: center;
    }
}
</style>

<div class="quiz-tabs">
    <ul class="nav nav-tabs" id="quizTabs" role="tablist">
        <?php foreach ($phases as $phase_key => $phase_name): ?>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= (isset($_SESSION['selected_phase']) && $phase_key === $_SESSION['selected_phase']) ? 'active' : '' ?>" 
                    id="<?= $phase_key ?>-tab" 
                    data-bs-toggle="tab" 
                    data-bs-target="#<?= $phase_key ?>" 
                    type="button" 
                    role="tab"
                    onclick="selectPhase('<?= $phase_key ?>')">
                <?= htmlspecialchars($phase_name) ?>
            </button>
        </li>
        <?php endforeach; ?>
    </ul>
    
    <div class="tab-content" id="quizTabsContent">
        <?php foreach ($phases as $phase_key => $phase_name): ?>
        <div class="tab-pane fade <?= (isset($_SESSION['selected_phase']) && $phase_key === $_SESSION['selected_phase']) ? 'show active' : '' ?>" 
             id="<?= $phase_key ?>" 
             role="tabpanel">
            
            <?php
            // Vérifier l'état du quiz pour cette phase spécifique
            $table_check = $mysqli->query("SHOW TABLES LIKE 'quizz_results_phases'");
            if ($table_check && $table_check->num_rows > 0) {
                $stmt_phase = $mysqli->prepare('SELECT score, locked, start_time FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
                if ($stmt_phase) {
                    $stmt_phase->bind_param('is', $user_id, $phase_key);
                    $stmt_phase->execute();
                    $stmt_phase->bind_result($score_phase, $locked_phase, $start_time_phase);
                    $stmt_phase->fetch();
                    $stmt_phase->close();
                } else {
                    $score_phase = 0;
                    $locked_phase = 0;
                    $start_time_phase = null;
                }
            } else {
                // Utiliser l'ancienne table si la nouvelle n'existe pas
                $stmt_phase = $mysqli->prepare('SELECT score, locked, start_time FROM quizz_results WHERE user_id = ?');
                if ($stmt_phase) {
                    $stmt_phase->bind_param('i', $user_id);
                    $stmt_phase->execute();
                    $stmt_phase->bind_result($score_phase, $locked_phase, $start_time_phase);
                    $stmt_phase->fetch();
                    $stmt_phase->close();
                } else {
                    $score_phase = 0;
                    $locked_phase = 0;
                    $start_time_phase = null;
                }
            }
            ?>
            
            <?php if ($locked_phase == 1): ?>
                <!-- Quiz terminé pour cette phase -->
                <div class="quiz-phase-info">
                    <h3><?= htmlspecialchars($phase_name) ?></h3>
                    <p><?= ($current_lang === 'ar') ? 'تم إكمال الاختبار' : 'Quiz terminé' ?></p>
                    <div class="quiz-score-display">
                        <span class="score-value"><?= $score_phase ?>/200</span>
                        <span class="score-label"><?= __('points_label') ?></span>
                    </div>
                </div>
            <?php elseif ($start_time_phase): ?>
                <!-- Quiz en cours pour cette phase - Afficher le quiz complet -->
                <?php
                // Vérifier s'il y a des questions pour cette phase
                $questions_count = 0;
                foreach ($themes as $theme) {
                    $stmt_count = $mysqli->prepare("SELECT COUNT(*) FROM quizz_questions WHERE theme = ? AND phase = ?");
                    if ($stmt_count) {
                        $stmt_count->bind_param('ss', $theme, $phase_key);
                        $stmt_count->execute();
                        $result_count = $stmt_count->get_result();
                        $count = $result_count->fetch_row()[0];
                        $questions_count += $count;
                        $stmt_count->close();
                    }
                }
                
                // Si pas de questions pour cette phase, afficher un message
                if ($questions_count == 0) {
                    echo '<div class="quiz-phase-info">';
                    echo '<h3>' . htmlspecialchars($phase_name) . '</h3>';
                    echo '<p>' . (($current_lang === 'ar') ? 'لا توجد أسئلة لهذه المرحلة' : 'Aucune question disponible pour cette phase') . '</p>';
                    echo '<p><small>' . (($current_lang === 'ar') ? 'يرجى إضافة أسئلة في لوحة الإدارة' : 'Veuillez ajouter des questions via l\'interface admin') . '</small></p>';
                    echo '</div>';
                } else {
                    // Afficher le quiz directement dans l'onglet
                    echo '<div class="quiz-phase-info">';
                    echo '<h3>' . htmlspecialchars($phase_name) . '</h3>';
                    echo '<p>' . (($current_lang === 'ar') ? 'الاختبار قيد التقدم' : 'Quiz en cours') . '</p>';
                    echo '<p><small>' . (($current_lang === 'ar') ? 'سيتم عرض الأسئلة هنا' : 'Les questions s\'afficheront ici') . '</small></p>';
                    echo '</div>';
                }
                ?>
            <?php else: ?>
                <!-- Quiz pas encore commencé pour cette phase -->
                <?php
                // Vérifier s'il y a des questions pour cette phase
                $questions_count = 0;
                foreach ($themes as $theme) {
                    $stmt_count = $mysqli->prepare("SELECT COUNT(*) FROM quizz_questions WHERE theme = ? AND phase = ?");
                    if ($stmt_count) {
                        $stmt_count->bind_param('ss', $theme, $phase_key);
                        $stmt_count->execute();
                        $result_count = $stmt_count->get_result();
                        $count = $result_count->fetch_row()[0];
                        $questions_count += $count;
                        $stmt_count->close();
                    }
                }
                
                // Si pas de questions pour cette phase, afficher un message
                if ($questions_count == 0) {
                    echo '<div class="quiz-phase-info">';
                    echo '<h3>' . htmlspecialchars($phase_name) . '</h3>';
                    echo '<p>' . (($current_lang === 'ar') ? 'لا توجد أسئلة لهذه المرحلة' : 'Aucune question disponible pour cette phase') . '</p>';
                    echo '<p><small>' . (($current_lang === 'ar') ? 'يرجى إضافة أسئلة في لوحة الإدارة' : 'Veuillez ajouter des questions via l\'interface admin') . '</small></p>';
                    echo '</div>';
                } else {
                    // Afficher l'écran de démarrage du quiz pour cette phase
                    ?>
                    <div class="quiz-phase-info">
                        <h3><?= htmlspecialchars($phase_name) ?></h3>
                        <p><?= ($current_lang === 'ar') ? 'اختبار مخصص لهذه المرحلة' : 'Quiz spécialisé pour cette phase' ?></p>
                    </div>
                    
                    <div class="quiz-stats">
                        <div class="quiz-stat">
                            <div class="stat-label"><?= __('theme') ?></div>
                            <div class="stat-value"><?= count($themes) ?></div>
                        </div>
                        <div class="quiz-stat">
                            <div class="stat-label"><?= __('question') ?></div>
                            <div class="stat-value">20</div>
                        </div>
                        <div class="quiz-stat">
                            <div class="stat-label"><?= __('score_label') ?></div>
                            <div class="stat-value">200 <?= __('points_label') ?></div>
                        </div>
                    </div>
                    
                    <form method="post" style="text-align: center; margin-top: 20px;">
                        <input type="hidden" name="phase" value="<?= $phase_key ?>">
                        <button type="submit" name="start_quizz" class="btn btn-success btn-lg">
                            <?= ($current_lang === 'ar') ? 'بدء الاختبار' : 'Commencer le quiz' ?>
                        </button>
                    </form>
                    <?php
                }
                ?>
            <?php endif; ?>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<script>
function selectPhase(phaseKey) {
    // Créer un formulaire pour changer de phase
    const form = document.createElement('form');
    form.method = 'POST';
    form.style.display = 'none';
    
    const phaseInput = document.createElement('input');
    phaseInput.type = 'hidden';
    phaseInput.name = 'phase';
    phaseInput.value = phaseKey;
    
    const actionInput = document.createElement('input');
    actionInput.type = 'hidden';
    actionInput.name = 'select_phase';
    actionInput.value = '1';
    
    form.appendChild(phaseInput);
    form.appendChild(actionInput);
    document.body.appendChild(form);
    form.submit();
}
</script>

<?php

// --- AJOUT : Affichage de l'écran de fin si le quizz est terminé ---
if ($locked == 1) {
  // Afficher l'écran de fin avec le score
  ?>
  <style>
    .quizz-finish {
      min-height: 60vh;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      max-width: 650px;
      margin: 0 auto;
      background: linear-gradient(135deg, #c7c7c7 60%, #fffbe6 100%);
      border-radius: 28px;
      box-shadow: 0 8px 40px #0003;
      padding: 48px 32px 40px 32px;
      text-align: center;
      border: 3px solid #fffbe6;
      position: relative;
      top: 10vh;
    }
    .quizz-finish .emoji {
      font-size: 2.7rem;
      margin-bottom: 12px;
      display: block;
    }
    .quizz-finish h2 {
      color: #23232b;
      font-size: 2.2rem;
      font-weight: 900;
      margin-bottom: 18px;
      letter-spacing: 1px;
      text-shadow: 0 2px 8px #fff7;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 12px;
    }
    .quizz-finish .score-message {
      color: #23232b;
      font-size: 1.18rem;
      font-weight: 600;
      margin-bottom: 18px;
      background: #fffbe6cc;
      border-radius: 12px;
      padding: 14px 10px 10px 10px;
      box-shadow: 0 2px 8px #ffb30022;
      line-height: 1.5;
      text-shadow: 0 2px 8px #fff7;
    }
    .quizz-finish .score-value {
      color: #ffb300;
      font-size: 2.2rem;
      font-weight: 900;
      margin-bottom: 10px;
      text-shadow: 0 2px 8px #fffbe6;
    }
    .quizz-finish .score-info {
      color: #888;
      font-size: 1.05rem;
      margin-bottom: 10px;
    }
    .quizz-finish .btn-home {
      background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
      color: #23232b;
      border: none;
      border-radius: 10px;
      font-weight: 800;
      font-size: 1.18rem;
      padding: 14px 38px;
      transition: background 0.18s, color 0.18s, transform 0.12s;
      display: block;
      margin: 32px auto 0 auto;
      box-shadow: 0 2px 12px #ffb30033;
      letter-spacing: 1px;
      cursor: pointer;
    }
    .quizz-finish .btn-home:hover {
      background: #fffbe6;
      color: #ffb300;
      transform: scale(1.05);
    }

    /* Styles RTL pour l'arabe */
    .lang-ar .quizz-finish {
      text-align: center;
    }
    
    .lang-ar .quizz-wait {
      text-align: center;
    }
    
    .lang-ar .quizz-container {
      text-align: right;
    }
    
    .lang-ar .quizz-title {
      text-align: center;
    }
    
    .lang-ar .quizz-question {
      text-align: right;
    }
    
    .lang-ar .quizz-choice-label {
      text-align: right;
    }
    
    .lang-ar .quizz-btn {
      text-align: center;
    }
  </style>
  <div class="quizz-finish">
    <span class="emoji">🎉</span>
    <h2><?= __('quiz_finished') ?></h2>
    <div class="score-message">
      <?= __('quiz_completed_message') ?>
    </div>
    <div class="score-value"><?= $score_locked ?>/200</div>
    <div class="score-info"><?= __('quiz_score_info') ?></div>
    <a href="home.php" class="btn-home"><?= __('back_home') ?></a>
  </div>
  <?php
  include 'templates/footer.php';
  exit;
}

if ($start_time_db) {
    // La date en base est en UTC, on la lit en UTC
    $dt = new DateTime($start_time_db, new DateTimeZone('UTC'));
    $start_timestamp = $dt->getTimestamp();
    $time_left = $time_limit - (time() - $start_timestamp);
} else {
    $time_left = $time_limit;
}
if ($time_left < 0) $time_left = 0;

// --- AJOUT : Si le temps est écoulé, terminer le quizz et afficher l'écran de fin ---
if ($time_left <= 0 && $locked != 1) {
  // Calculer le score partiel
  $score = 0;
  if (isset($_SESSION['quizz_answers'])) {
    foreach ($_SESSION['quizz_answers'] as $qid => $user_answer) {
      $question = getTranslatedQuestion($mysqli, $qid, $current_lang);
      if ($user_answer === $question['answer']) $score += 10;
    }
  }
  // Verrouiller le quizz
  $stmt = $mysqli->prepare('INSERT INTO quizz_results_phases (user_id, phase, score, completed_at, locked) VALUES (?, ?, ?, UTC_TIMESTAMP(), 1) ON DUPLICATE KEY UPDATE score = VALUES(score), completed_at = VALUES(completed_at), locked = 1');
  $stmt->bind_param('isi', $user_id, $selected_phase, $score);
  $stmt->execute();
  $stmt->close();
  unset($_SESSION['quizz_started'], $_SESSION['quizz_start_time'], $_SESSION['quizz_progress'], $_SESSION['quizz_answers'], $_SESSION['quizz_theme_idx'], $_SESSION['quizz_q_idx'], $_SESSION['quizz_show_answer']);
  // Afficher l'écran de fin avec message temps écoulé
  ?>
  <style>
    .quizz-finish {
      min-height: 60vh;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      max-width: 650px;
      margin: 0 auto;
      background: linear-gradient(135deg, #c7c7c7 60%, #fffbe6 100%);
      border-radius: 28px;
      box-shadow: 0 8px 40px #0003;
      padding: 48px 32px 40px 32px;
      text-align: center;
      border: 3px solid #fffbe6;
      position: relative;
      top: 10vh;
    }
    .quizz-finish .emoji {
      font-size: 2.7rem;
      margin-bottom: 12px;
      display: block;
    }
    .quizz-finish h2 {
      color: #e53935;
      font-size: 2.2rem;
      font-weight: 900;
      margin-bottom: 18px;
      letter-spacing: 1px;
      text-shadow: 0 2px 8px #fff7;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 12px;
    }
    .quizz-finish .score-message {
      color: #23232b;
      font-size: 1.18rem;
      font-weight: 600;
      margin-bottom: 18px;
      background: #fffbe6cc;
      border-radius: 12px;
      padding: 14px 10px 10px 10px;
      box-shadow: 0 2px 8px #ffb30022;
      line-height: 1.5;
      text-shadow: 0 2px 8px #fff7;
    }
    .quizz-finish .score-value {
      color: #ffb300;
      font-size: 2.2rem;
      font-weight: 900;
      margin-bottom: 10px;
      text-shadow: 0 2px 8px #fffbe6;
    }
    .quizz-finish .score-info {
      color: #888;
      font-size: 1.05rem;
      margin-bottom: 10px;
    }
    .quizz-finish .btn-home {
      background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
      color: #23232b;
      border: none;
      border-radius: 10px;
      font-weight: 800;
      font-size: 1.18rem;
      padding: 14px 38px;
      transition: background 0.18s, color 0.18s, transform 0.12s;
      display: block;
      margin: 32px auto 0 auto;
      box-shadow: 0 2px 12px #ffb30033;
      letter-spacing: 1px;
      cursor: pointer;
      animation: pulse 1.2s infinite alternate;
    }
    .quizz-finish .btn-home:hover {
      background: #fffbe6;
      color: #ffb300;
      transform: scale(1.06);
    }
    @media (max-width: 600px) {
      .quizz-finish {
        padding: 18px 2vw 18px 2vw;
        min-height: 50vh;
      }
      .quizz-finish h2 {
        font-size: 1.3rem;
      }
      .quizz-finish .emoji {
        font-size: 1.5rem;
      }
      .quizz-finish .btn-home {
        font-size: 1rem;
        padding: 10px 18px;
      }
    }
  </style>
  <div class="quizz-finish">
    <span class="emoji">⏰</span>
    <h2><?= __('time_expired') ?></h2>
    <div class="score-message">
      <div class="score-value"><?= str_replace('{score}', $score, __('score_points')) ?></div>
      <div class="score-info"><?= __('correct_answer_points') ?></div>
      <div><?= __('time_finished_message') ?><br><?= str_replace('{count}', $score / 10, __('questions_answered_correctly')) ?></div>
    </div>
    <a style="text-decoration: none;" href="home.php" class="btn-home"><span style="vertical-align:middle;display:inline-block;margin-right:8px; margin-top: -12px;"><svg xmlns='http://www.w3.org/2000/svg' width='22' height='22' viewBox='0 0 24 24' fill='none' stroke='#23232b' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'><path d='M3 9.5L12 4l9 5.5V20a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V9.5z'/><polyline points='9 22 9 12 15 12 15 22'/></svg></span><?= __('back_home') ?></a>
  </div>
  <?php
  include 'templates/footer.php';
  exit;
}

// Si aucune phase n'est sélectionnée, afficher la sélection de phase
if (!isset($_SESSION['selected_phase'])) {
    // Afficher seulement les tabs de sélection de phase
    include 'templates/header.php';
    // Le contenu des tabs est déjà affiché plus haut
    include 'templates/footer.php';
    exit;
}

// Le quiz s'affiche maintenant directement dans les onglets
if (false) {
?>
  <style>
    body,
    html {
      height: 100%;
    }

    .quizz-wait {
      min-height: 60vh;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      max-width: 650px;
      margin: 0 auto;
      background: linear-gradient(135deg, #c7c7c7 60%, #fffbe6 100%);
      border-radius: 28px;
      box-shadow: 0 8px 40px #0003;
      padding: 48px 32px 40px 32px;
      text-align: center;
      border: 3px solid #fffbe6;
      position: relative;
      top: 10vh;
    }

    .quizz-wait .emoji {
      font-size: 2.7rem;
      margin-bottom: 12px;
      display: block;
    }

    .quizz-wait h2 {
      color: #23232b;
      font-size: 2.2rem;
      font-weight: 900;
      margin-bottom: 18px;
      letter-spacing: 1px;
      text-shadow: 0 2px 8px #fff7;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 12px;
    }

    .quizz-wait .wait-message {
      color: #23232b;
      font-size: 1.18rem;
      font-weight: 600;
      margin-bottom: 18px;
      background: #fffbe6cc;
      border-radius: 12px;
      padding: 14px 10px 10px 10px;
      box-shadow: 0 2px 8px #ffb30022;
      line-height: 1.5;
      text-shadow: 0 2px 8px #fff7;
    }

    .quizz-wait .wait-warning {
      color: #e53935;
      font-weight: 800;
      font-size: 1.08rem;
      margin-bottom: 10px;
      margin-top: 8px;
      letter-spacing: 1px;
      text-shadow: 0 2px 8px #fff7;
    }

    .quizz-btn {
      background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
      color: #23232b;
      border: none;
      border-radius: 10px;
      font-weight: 800;
      font-size: 1.18rem;
      padding: 14px 38px;
      transition: background 0.18s, color 0.18s, transform 0.12s;
      display: block;
      margin: 32px auto 0 auto;
      box-shadow: 0 2px 12px #ffb30033;
      letter-spacing: 1px;
      cursor: pointer;
      animation: pulse 1.2s infinite alternate;
    }

    .quizz-btn:hover {
      background: #fffbe6;
      color: #ffb300;
      transform: scale(1.06);
    }

    @keyframes pulse {
      0% {
        box-shadow: 0 2px 12px #ffb30033;
      }

      100% {
        box-shadow: 0 4px 24px #ffb30077;
      }
    }

    @media (max-width: 600px) {
      .quizz-wait {
        padding: 18px 2vw 18px 2vw;
        min-height: 50vh;
      }

      .quizz-wait h2 {
        font-size: 1.3rem;
      }

      .quizz-wait .emoji {
        font-size: 1.5rem;
      }

      .quizz-btn {
        font-size: 1rem;
        padding: 10px 18px;
      }
    }
  </style>
  <div class="quizz-wait">
    <span style="display: none;" class="emoji">⚽️</span>
    <h2><?= __('ready_for_quiz') ?></h2>
    <div class="wait-message">
      <b><?= __('quiz_instructions') ?></b><br>
      <?= __('quiz_auto_close') ?><br>
      <span style="color:#4caf50;"><?= __('good_luck') ?></span>
    </div>
    <div style="display: none;" class="wait-warning">🚨 <?= __('only_one_attempt') ?></div>
    <form method="post">
      <button type="submit" name="start_quizz" class="quizz-btn">🚀 <?= __('start_quiz_button') ?></button>
    </form>
  </div>
<?php
  include 'templates/footer.php';
  exit;
}

// Initialisation de la progression
if (!isset($_SESSION['quizz_progress']) || !isset($_SESSION['quizz_table'])) {
  $progress = [];
  // Choisir la table selon la langue
  $table_name = ($current_lang === 'ar') ? 'quizz_questions_ar' : 'quizz_questions';
  
  // Récupérer la phase sélectionnée ou utiliser la première par défaut
  $selected_phase = $_SESSION['selected_phase'] ?? 'Phase de groupes';
  
  foreach (array_keys($themes) as $theme) {
    $progress[$theme] = [];
    $res = $mysqli->prepare("SELECT id FROM {$table_name} WHERE phase = ? AND theme = ? ORDER BY RAND() LIMIT 5");
    $res->bind_param('ss', $selected_phase, $theme);
    $res->execute();
    $result = $res->get_result();
    while ($row = $result->fetch_assoc()) {
      $progress[$theme][] = $row['id'];
    }
    $res->close();
  }
  $_SESSION['quizz_progress'] = $progress;
  $_SESSION['quizz_answers'] = [];
  $_SESSION['quizz_theme_idx'] = 0;
  $_SESSION['quizz_q_idx'] = 0;
  $_SESSION['quizz_show_answer'] = false;
  $_SESSION['quizz_table'] = $table_name; // Stocker la table utilisée
}





$theme_idx = $_SESSION['quizz_theme_idx'];
$q_idx = $_SESSION['quizz_q_idx'];
$theme = $theme_keys[$theme_idx];
$selected_phase = $_SESSION['selected_phase'] ?? 'Phase de groupes';

// S'assurer que la progression est valide
if (!isset($_SESSION['quizz_progress'][$theme]) || !isset($_SESSION['quizz_progress'][$theme][$q_idx])) {
    // Si la progression n'est pas valide, réinitialiser
    if (!isset($_SESSION['quizz_progress']) || !isset($_SESSION['quizz_table'])) {
        header('Location: quizz.php');
        exit;
    }
}

$question_id = $_SESSION['quizz_progress'][$theme][$q_idx];
$q = getTranslatedQuestion($mysqli, $question_id, $current_lang);
$options = [];
if (!empty($q['option1'])) $options[] = $q['option1'];
if (!empty($q['option2'])) $options[] = $q['option2'];
if (!empty($q['option3'])) $options[] = $q['option3'];
if (!empty($q['option4'])) $options[] = $q['option4'];
if (count($options) === 4) {
  shuffle($options);
} else {
  echo "<div style='color:red;font-weight:bold'>Erreur: la question ID {$q['id']} n'a pas 4 choix valides.</div>";
}
// Calcul de la progression
$current_question = $theme_idx * 5 + $q_idx + 1;
$total_questions = 20;
$progress_percent = intval($current_question / $total_questions * 100);
$progress_ratio = max(0, min(1, $current_question / $total_questions));
$min = floor($time_left / 60);
$sec = $time_left % 60;
$time_str = sprintf('%02d:%02d', $min, $sec);

// --- Calcul du score courant ---
$score_courant = 0;
if (isset($_SESSION['quizz_answers'])) {
  foreach ($_SESSION['quizz_answers'] as $qid => $user_answer) {
    $question = getTranslatedQuestion($mysqli, $qid, $current_lang);
    if ($user_answer === $question['answer']) $score_courant += 10;
  }
}
?>
<script>
  let timeLeft = <?= $time_left ?>;
  const totalTime = <?= $time_limit ?>;

  function getProgressColor(timeLeft) {
    if (timeLeft <= 60) return '#e53935';
    if (timeLeft > 150) return '#4caf50';
    if (timeLeft > 60) return '#ffb300';
    return '#e53935';
  }

  function updateTimer() {
    if (timeLeft <= 0) {
      document.getElementById('timerText').innerText = '00:00';
      document.getElementById('quizz-form').submit();
      return;
    }
    let min = Math.floor(timeLeft / 60);
    let sec = timeLeft % 60;
    let timeStr = (min < 10 ? '0' : '') + min + ':' + (sec < 10 ? '0' : '') + sec;
    let ratio = timeLeft / totalTime;
    let circle = 2 * Math.PI * 20;
    let offset = circle * (1 - ratio);
    let color = getProgressColor(timeLeft);
    document.getElementById('timerText').innerText = timeStr;
    let ring = document.querySelector('.timer-progress-ring circle[stroke-dasharray]');
    ring.setAttribute('stroke', color);
    ring.setAttribute('stroke-dashoffset', offset);
    let ringWrap = document.getElementById('timerRing');
    if (timeLeft <= 60) {
      ringWrap.style.animation = 'pulse-fast 0.7s infinite alternate';
    } else {
      ringWrap.style.animation = '';
    }
    timeLeft--;
    setTimeout(updateTimer, 1000);
  }
  window.onload = updateTimer;
</script>

<script>
// Gestion des tabs de phases
document.addEventListener('DOMContentLoaded', function() {
    // Initialiser Bootstrap tabs
    var triggerTabList = [].slice.call(document.querySelectorAll('#quizTabs button'));
    triggerTabList.forEach(function (triggerEl) {
        var tabTrigger = new bootstrap.Tab(triggerEl);
        
        triggerEl.addEventListener('click', function (event) {
            event.preventDefault();
            tabTrigger.show();
        });
    });
    
    // Mettre à jour l'onglet actif selon la phase courante
    var currentPhase = '<?= isset($_SESSION['selected_phase']) ? $_SESSION['selected_phase'] : 'Phase de groupes' ?>';
    var activeTab = document.getElementById(currentPhase + '-tab');
    if (activeTab) {
        var tab = new bootstrap.Tab(activeTab);
        tab.show();
    }
    
    // Désactiver les onglets si le quiz a commencé
    <?php if (isset($_SESSION['quizz_started'])): ?>
    var allTabs = document.querySelectorAll('#quizTabs button');
    allTabs.forEach(function(tab) {
        if (tab.id !== currentPhase + '-tab') {
            tab.disabled = true;
            tab.style.opacity = '0.5';
        }
    });
    <?php endif; ?>
});

// Fonction pour sélectionner une phase
function selectPhase(phase) {
    if (!<?= isset($_SESSION['quizz_started']) ? 'true' : 'false' ?>) {
        var form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = '<input type="hidden" name="select_phase" value="1"><input type="hidden" name="phase" value="' + phase + '">';
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
<style>
  .quizz-container {
    max-width: 700px;
    margin: 40px auto 30px auto;
    background: linear-gradient(135deg, #23232b 80%, #ffb30022 100%);
    border-radius: 18px;
    box-shadow: 0 4px 24px #0005;
    padding: 32px 24px 24px 24px;
  }

  .quizz-title {
    color: #ffb300;
    font-size: 1.3rem;
    font-weight: 900;
    text-align: center;
    margin-bottom: 18px;
    letter-spacing: 1px;
    text-shadow: 0 2px 8px #fff2;
  }

  .quizz-question {
    background: #29293a;
    border-radius: 14px;
    margin-bottom: 18px;
    padding: 18px 16px;
    box-shadow: 0 2px 8px #0002;
    border: 2px solid #ffb30044;
  }

  .quizz-label {
    color: #ffb300;
    font-weight: 700;
    font-size: 1.13rem;
    margin-bottom: 2px;
    display: block;
  }

  .quizz-btn {
    background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
    color: #23232b;
    border: none;
    border-radius: 10px;
    font-weight: 800;
    font-size: 1.13rem;
    padding: 10px 28px;
    transition: background 0.15s, color 0.15s;
    display: block;
    margin: 24px auto 0 auto;
    box-shadow: 0 2px 8px #ffb30033;
  }

  .quizz-btn:hover {
    background: #fffbe6;
    color: #ffb300;
  }

  .quizz-feedback {
    font-size: 1.18rem;
    font-weight: 800;
    margin-top: 8px;
    text-align: center;
  }

  .quizz-feedback.ok {
    color: #4caf50;
  }

  .quizz-feedback.ko {
    color: #e53935;
  }

  /* Style pour le choix sélectionné */
  .quizz-choice-label {
    color: #fff;
    font-size: 1.13rem;
    display: flex;
    align-items: center;
    gap: 10px;
    cursor: pointer;
    border-radius: 8px;
    padding: 7px 12px;
    margin-bottom: 10px;
    border: 2px solid transparent;
    transition: background 0.15s, border 0.15s, color 0.15s;
  }

  .quizz-choice-label.selected {
    background: #fffbe6;
    color: #23232b !important;
    border: 2px solid #ffb300;
    font-weight: 800;
  }

  .quizz-choice-label.correct {
    background: #e8f5e9;
    color: #23232b !important;
    border: 2px solid #4caf50;
    font-weight: 800;
  }

  .quizz-choice-label.incorrect {
    background: #ffebee;
    color: #23232b !important;
    border: 2px solid #e53935;
    font-weight: 800;
  }

  .progress-bar-quizz {
    width: 100%;
    background: #fffbe6;
    border-radius: 10px;
    height: 18px;
    margin-bottom: 24px;
    box-shadow: 0 2px 8px #ffb30022;
    overflow: hidden;
  }

  .progress-bar-quizz-inner {
    height: 100%;
    background: linear-gradient(90deg, #ffb300 60%, #4caf50 100%);
    border-radius: 10px 0 0 10px;
    transition: width 0.3s;
    font-weight: 800;
    color: #23232b;
    font-size: 1.08rem;
    display: flex;
    align-items: center;
    min-width: 10%;
    padding-left: 10px;
  }

  .progress-bar-quizz-label {
    font-weight: 800;
    color: #23232b;
    font-size: 1.08rem;
    display: flex;
    justify-content: space-between;
    padding-left: 10px;
  }

  .timer-clock {
    display: inline-block;
    vertical-align: middle;
    margin-right: 8px;
    animation: rotate-clock 1.2s linear infinite;
  }

  @keyframes rotate-clock {
    0% {
      transform: rotate(0deg);
    }

    100% {
      transform: rotate(360deg);
    }
  }

  .timer-clock-sync {
    display: inline-block;
    vertical-align: middle;
    margin-right: 12px;
    width: 54px;
    height: 54px;
    position: relative;
  }

  .timer-clock-sync svg {
    width: 54px;
    height: 54px;
    display: block;
  }

  .timer-clock-sync .clock-time {
    position: absolute;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -54%);
    font-size: 1.18rem;
    font-weight: 900;
    color: #e53935;
    text-shadow: 0 2px 8px #fffbe6, 0 1px 0 #fffbe6;
    pointer-events: none;
    letter-spacing: 1px;
    font-family: 'Montserrat', Arial, sans-serif;
  }

  .timer-progress-ring {
    position: relative;
    width: 44px;
    height: 44px;
    display: inline-block;
    vertical-align: middle;
  }

  .timer-progress-ring svg {
    width: 44px;
    height: 44px;
    display: block;
    transform: rotate(0deg);
  }

  .timer-progress-ring .timer-text {
    position: absolute;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -54%);
    font-size: 1.08rem;
    font-weight: 900;
    color: #23232b;
    text-shadow: 0 2px 8px #fffbe6, 0 1px 0 #fffbe6;
    pointer-events: none;
    font-family: 'Montserrat', Arial, sans-serif;
    letter-spacing: 1px;
  }

  .timer-bar-container {
    position: relative;
    min-height: 40px;
    display: flex;
    align-items: center;
    justify-content: flex-start;
  }

  .timer-bar-horloge-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 18px;
    margin-bottom: 18px;
  }

  .progress-bar-horiz {
    flex: 1 1 auto;
    height: 18px;
    background: #fffbe6;
    border-radius: 10px;
    overflow: hidden;
    position: relative;
    box-shadow: 0 2px 8px #ffb30022;
  }

  .progress-bar-horiz-inner {
    height: 100%;
    background: linear-gradient(90deg, #4caf50 0%, #ffb300 80%, #e53935 100%);
    border-radius: 10px 0 0 10px;
    transition: width 0.3s;
    width: 0;
  }

  .timer-questions-progress {
    display: flex;
    flex-direction: column;
    align-items: center;
    margin-left: 8px;
    min-width: 54px;
  }

  .timer-questions-progress .q-progress {
    font-size: 1.08rem;
    font-weight: 800;
    color: #23232b;
    background: #fffbe6;
    border-radius: 8px;
    padding: 2px 10px;
    margin-top: 4px;
    box-shadow: 0 2px 8px #ffb30022;
    letter-spacing: 1px;
  }

  .flex-timer-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 18px;
    margin-bottom: 18px;
  }

  .progress-bar-questions {
    flex: 1 1 auto;
    height: 18px;
    background: #fffbe6;
    border-radius: 10px;
    overflow: hidden;
    position: relative;
    box-shadow: 0 2px 8px #ffb30022;
    min-width: 120px;
    max-width: 400px;
  }

  .progress-bar-questions-inner {
    height: 100%;
    background: linear-gradient(90deg, #4caf50 0%, #ffb300 80%, #e53935 100%);
    border-radius: 10px 0 0 10px;
    transition: width 0.3s;
    width: 0;
  }

  .progress-bar-questions-label {
    position: absolute;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -54%);
    font-size: 1.08rem;
    font-weight: 800;
    color: #23232b;
    pointer-events: none;
    letter-spacing: 1px;
  }

  .timer-progress-ring {
    position: relative;
    width: 44px;
    height: 44px;
    display: inline-block;
    vertical-align: middle;
    margin-left: 12px;
  }

  .timer-progress-ring svg {
    width: 44px;
    height: 44px;
    display: block;
    transform: rotate(0deg);
  }

  .timer-progress-ring .timer-text {
    position: absolute;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -54%);
    font-size: 1.08rem;
    font-weight: 900;
    color: #23232b;
    text-shadow: 0 2px 8px #fffbe6, 0 1px 0 #fffbe6;
    pointer-events: none;
    font-family: 'Montserrat', Arial, sans-serif;
    letter-spacing: 1px;
  }

  .quizz-score-left {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    justify-content: center;
    min-width: 70px;
    margin-right: 10px;
  }
  .quizz-score-left .score-label {
    font-size: 0.95rem;
    color: #ffb300;
    font-weight: 700;
    margin-bottom: 2px;
  }
  .quizz-score-left .score-value {
    font-size: 1.18rem;
    font-weight: 900;
    color: #fff;
    text-shadow: 0 2px 8px #ffb30055;
  }

  @media (max-width: 600px) {
    .quizz-container {
      padding: 12px 2vw 18px 2vw;
    }

    .quizz-title {
      font-size: 1.3rem;
    }
  }

  @keyframes pulse-fast {
    0% {
      box-shadow: 0 0 0 0 #e5393555;
    }

    100% {
      box-shadow: 0 0 12px 6px #e53935aa;
    }
  }
</style>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    const radios = document.querySelectorAll('input[type=radio][name=selected_option]');
    radios.forEach(radio => {
      radio.addEventListener('change', function() {
        document.querySelectorAll('.quizz-choice-label').forEach(lab => lab.classList.remove('selected'));
        if (this.checked) {
          this.closest('label').classList.add('selected');
        }
      });
    });
  });
</script>
<div class="quizz-container">
  <div class="flex-timer-row">
    <div class="quizz-score-left">
      <span class="score-label"><?= __('score_label') ?></span>
      <span class="score-value"><?= $score_courant ?> <?= __('points_label') ?></span>
    </div>
    <div class="progress-bar-questions">
      <div class="progress-bar-questions-inner" id="progressBarQ" style="width: <?= $progress_percent ?>%;"></div>
      <div class="progress-bar-questions-label"><?= $current_question ?> / <?= $total_questions ?></div>
    </div>
    <span class="timer-progress-ring" id="timerRing" style="<?= ($time_left <= 60 ? 'animation: pulse-fast 0.7s infinite alternate;' : '') ?>">
      <svg viewBox="0 0 44 44">
        <circle cx="22" cy="22" r="20" stroke="#eee" stroke-width="4" fill="#fffbe6" />
        <circle cx="22" cy="22" r="20" stroke="<?= ($time_left <= 60 ? '#e53935' : ($time_left > 150 ? '#4caf50' : ($time_left > 60 ? '#ffb300' : '#e53935'))) ?>"
          stroke-width="4" fill="none"
          stroke-dasharray="<?= 2 * M_PI * 20 ?>"
          stroke-dashoffset="<?= (2 * M_PI * 20) * (1 - $time_left / $time_limit) ?>"
          style="transition: stroke 0.3s, stroke-dashoffset 1s;" />
      </svg>
      <span class="timer-text" id="timerText"><?= $time_str ?></span>
    </span>
  </div>
  <div class="quizz-title">
    <?= __('theme') ?> : <?= htmlspecialchars($phases[$selected_phase]) ?> - <?= htmlspecialchars($themes[$theme]) ?> (<?= str_replace('{current}', ($q_idx + 1), __('question_number')) ?>)
  </div>
  <form method="post" id="quizz-form">
    <div class="quizz-question">
      <span class="quizz-label"><?= htmlspecialchars($q['question']) ?></span>
      <?php if (!$_SESSION['quizz_show_answer']): ?>
        <?php foreach ($options as $opt): ?>
          <div>
            <label class="quizz-choice-label">
              <input type="radio" name="selected_option" value="<?= htmlspecialchars($opt) ?>" required style="accent-color:#ffb300; width:20px; height:20px;">
              <?= htmlspecialchars($opt) ?>
            </label>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <?php
        $user_answer = $_SESSION['quizz_answers'][$question_id];
        $is_correct = ($user_answer === $q['answer']);
        ?>
        <?php foreach ($options as $opt): ?>
          <?php
          $labelClass = 'quizz-choice-label';
          if ($user_answer === $opt && $opt === $q['answer']) $labelClass .= ' correct';
          elseif ($user_answer === $opt && $opt !== $q['answer']) $labelClass .= ' incorrect';
          ?>
          <div>
            <label class="<?= $labelClass ?>">
              <input type="radio" disabled <?= ($user_answer === $opt) ? 'checked' : '' ?> style="accent-color:#ffb300; width:20px; height:20px;">
              <?= htmlspecialchars($opt) ?>
              <?php if ($user_answer === $opt && $opt === $q['answer']): ?>
                <span style="color:#4caf50; font-size:1.5rem; margin-left:8px;">&#10003;</span>
              <?php elseif ($user_answer === $opt && $opt !== $q['answer']): ?>
                <span style="color:#e53935; font-size:1.5rem; margin-left:8px;">&#10007;</span>
              <?php elseif ($opt === $q['answer']): ?>
                <span style="color:#4caf50; font-size:1.5rem; margin-left:8px;">&#10003;</span>
              <?php endif; ?>
            </label>
          </div>
        <?php endforeach; ?>
      <?php endif; ?>
    </div>
    <?php if (!$_SESSION['quizz_show_answer']): ?>
      <button type="submit" class="quizz-btn"><?= __('validate') ?></button>
    <?php else: ?>
      <button type="submit" name="next_question" value="1" class="quizz-btn"><?= __('next') ?></button>
    <?php endif; ?>
  </form>
</div>
<?php include 'templates/footer.php'; ?>