<?php
// Inclure le système de langue en premier
require_once 'includes/language.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if(!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}
include 'templates/header.php';
?>
<style>
/* Styles RTL pour l'arabe */
.lang-ar .bg-dark {
    text-align: right;
}

.lang-ar h5 {
    text-align: right;
}

.lang-ar ul {
    padding-inline-start: 0px !important;
}

.lang-ar li {
    text-align: right;
}

.lang-ar p {
    text-align: right;
}
</style>
<div class="container mt-4">
    <h2 class="text-center mb-4" style="color:white;"><?= __('rules_title') ?></h2>
    <div class="bg-dark text-white p-4 rounded" style="max-width:700px;margin:auto;">
        <h5><?= __('participation_conditions') ?></h5>
        <ul>
            <li><?= __('employees_only') ?></li>
            <li><?= __('one_account_per_person') ?></li>
            <li><?= __('predictions_deadline') ?></li>
            <li><?= __('points_attribution') ?></li>
            <li><?= __('tie_breaker') ?></li>
            <li><?= __('fraud_disqualification') ?></li>
        </ul>
        <p><?= __('contact_responsible') ?></p>
        <hr>
        <p class="text-muted"><?= __('rules_adaptable') ?></p>
    </div>
</div>
<?php include 'templates/footer.php'; ?> 