<?php
// Inclure le système de langue en premier
require_once 'includes/language.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if(!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}
include 'templates/header.php';

// Fonction pour obtenir le titre traduit d'une phase
function getPhaseTitreGoodies($phase, $current_lang) {
    $phase_translations = [
        'fr' => [
            'Phase de groupes' => 'Phase de groupes',
            '8e de finale' => '8e de finale',
            'Quart de finale' => 'Quart de finale',
            'Demi-finale' => 'Demi-finale',
            'Match pour la 3e place' => 'Match pour la 3e place',
            'Finale' => 'Finale'
        ],
        'ar' => [
            'Phase de groupes' => 'مرحلة المجموعات',
            '8e de finale' => 'دور الثمن النهائي',
            'Quart de finale' => 'ربع النهائي',
            'Demi-finale' => 'نصف النهائي',
            'Match pour la 3e place' => 'مباراة المركز الثالث',
            'Finale' => 'النهائي'
        ]
    ];
    return $phase_translations[$current_lang][$phase] ?? $phase;
}

$current_lang = getCurrentLanguage();
?>
<style>
/* Styles RTL pour l'arabe */
.lang-ar .bg-dark {
    text-align: right;
}

.lang-ar h5 {
    text-align: right;
}

.lang-ar ul {
    padding-inline-start: 0px !important;
}

.lang-ar li {
    text-align: right;
}

.lang-ar p {
    text-align: right;
}

.lang-ar .container {
    text-align: right;
}

.lang-ar h1,
.lang-ar h2 {
    text-align: center;
}

.section-divider {
    border-top: 2px solid #ffb300;
    margin: 40px 0;
    opacity: 0.3;
}

.tab-content {
    background: #23232b;
    border-radius: 18px;
    box-shadow: 0 4px 24px #0005;
    padding: 32px 24px 24px 24px;
    margin-top: 20px;
}

.nav-tabs .nav-link {
    color: #ffb300;
    border: 1px solid transparent;
    border-radius: 8px 8px 0 0;
    margin-right: 5px;
}

.nav-tabs .nav-link.active {
    color: #23232b;
    background-color: #ffb300;
    border-color: #ffb300;
}

.nav-tabs .nav-link:hover {
    color: #fff;
    border-color: #ffb300;
}

/* Mobile margin-top pour éviter que le titre soit collé avec le header */
@media (max-width: 767.98px) {
    body {
        padding-top: 40px;
        padding-bottom: 90px;
    }
    
    .container.mt-4 {
        margin-top: 50px !important;
    }
}

@media (min-width: 1200px) {
    .h1, h1 {
        font-size: 2.1rem;
    }
}
</style>

<div class="container mt-4" style="max-width: 800px;">
    <h1 class="text-center mb-4" style="color: #ffffff; font-weight: 800;"><?= __('rules_and_goodies') ?></h1>
    
    <!-- Navigation par onglets -->
    <ul class="nav nav-tabs" id="reglementGoodiesTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="goodies-tab" data-bs-toggle="tab" data-bs-target="#goodies" type="button" role="tab" aria-controls="goodies" aria-selected="true">
                <i class="fas fa-gift"></i> <?= __('goodies') ?>
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="reglement-tab" data-bs-toggle="tab" data-bs-target="#reglement" type="button" role="tab" aria-controls="reglement" aria-selected="false">
                <i class="fas fa-gavel"></i> <?= __('rules') ?>
            </button>
        </li>
    </ul>
    
    <!-- Contenu des onglets -->
    <div class="tab-content" id="reglementGoodiesTabsContent">
        <!-- Onglet Règlement -->
        <div class="tab-pane fade" id="reglement" role="tabpanel" aria-labelledby="reglement-tab">
            <h1 class="text-center mb-4" style="color: #ffb300; font-weight: 800;"><?= __('reglement_title') ?></h1>
            
            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_1_title') ?></h3>
                <p><?= __('article_1_text') ?></p>
                <p><?= __('article_1_purpose') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_2_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_2_point_1') ?></p>
                <p><strong>2.</strong> <?= __('article_2_point_2') ?></p>
                <p><strong>3.</strong> <?= __('article_2_point_3') ?></p>
                <ul style="margin-left: 20px; margin-top: 10px;">
                    <li><?= __('article_2_point_3_a') ?></li>
                    <li><?= __('article_2_point_3_b') ?></li>
                    <li><?= __('article_2_point_3_c') ?></li>
                </ul>
                <p><strong>4.</strong> <?= __('article_2_point_4') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_3_title') ?></h3>
                <p><?= __('article_3_text') ?></p>
                <p><?= __('article_3_note') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_4_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_4_point_1') ?></p>
                <p><strong>2.</strong> <?= __('article_4_point_2') ?></p>
                <p><strong>3.</strong> <?= __('article_4_point_3') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_5_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_5_point_1') ?></p>
                <p><?= __('article_5_point_1_examples') ?></p>
                <ul style="margin-left: 20px; margin-top: 10px;">
                    <li><?= __('article_5_point_1_a') ?></li>
                    <li><?= __('article_5_point_1_b') ?></li>
                    <li><?= __('article_5_point_1_c') ?></li>
                    <li><?= __('article_5_point_1_d') ?></li>
                    <li><?= __('article_5_point_1_e') ?></li>
                </ul>
                <p><strong>2.</strong> <?= __('article_5_point_2') ?></p>
                <p><strong>3.</strong> <?= __('article_5_point_3') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_6_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_6_point_1') ?></p>
                <p><strong>2.</strong> <?= __('article_6_point_2') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_7_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_7_point_1') ?></p>
                <ul style="margin-left: 20px; margin-top: 10px;">
                    <li><?= __('article_7_point_1_a') ?></li>
                    <li><?= __('article_7_point_1_b') ?></li>
                </ul>
                <p><strong>2.</strong> <?= __('article_7_point_2') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_8_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_8_point_1') ?></p>
                <ul style="margin-left: 20px; margin-top: 10px;">
                    <li><?= __('article_8_point_1_a') ?></li>
                    <li><?= __('article_8_point_1_b') ?></li>
                    <li><?= __('article_8_point_1_c') ?></li>
                </ul>
                <p><strong>2.</strong> <?= __('article_8_point_2') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_9_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_9_point_1') ?></p>
                <p><strong>2.</strong> <?= __('article_9_point_2') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_10_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_10_point_1') ?></p>
                <p><strong>2.</strong> <?= __('article_10_point_2') ?></p>
                <p><strong>3.</strong> <?= __('article_10_point_3') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_11_title') ?></h3>
                <p><?= __('article_11_text') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_12_title') ?></h3>
                <p><?= __('article_12_text') ?></p>
            </div>

            <div class="bg-dark text-white rounded mb-4" style="line-height: 1.8;">
                <h3 style="color: #ffb300; margin-top: 0; margin-bottom: 15px;"><?= __('article_13_title') ?></h3>
                <p><strong>1.</strong> <?= __('article_13_point_1') ?></p>
                <p><strong>2.</strong> <?= __('article_13_point_2') ?></p>
                <p><strong>3.</strong> <?= __('article_13_point_3') ?></p>
                <p><strong>4.</strong> <?= __('article_13_point_4') ?></p>
            </div>
        </div>
        
        <!-- Onglet Cadeaux -->
        <div class="tab-pane fade show active" id="goodies" role="tabpanel" aria-labelledby="goodies-tab">
            <h1 style="color:#ffb300;text-align:center;font-weight:800;margin-bottom:40px;"><?= __('goodies_title') ?></h1>

            <div class="goodies-bloc" style="margin-bottom:32px;">
                <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('group_phase'), $current_lang) ?></h2>
                <p style="color:white;"><?= __('group_phase_goodies') ?></p>
            </div>

            <div class="goodies-bloc" style="margin-bottom:32px;">
                <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('round_of_16'), $current_lang) ?></h2>
                <p style="color:white;"><?= __('round_of_16_goodies') ?></p>
            </div>

            <div class="goodies-bloc" style="margin-bottom:32px;">
                <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('quarter_final'), $current_lang) ?></h2>
                <p style="color:white;"><?= __('quarter_final_goodies') ?></p>
            </div>

            <div class="goodies-bloc" style="margin-bottom:32px;">
                <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('semi_final'), $current_lang) ?></h2>
                <p style="color:white;"><?= __('semi_final_goodies') ?></p>
            </div>

            <div class="goodies-bloc" style="margin-bottom:32px;">
                <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('third_place_match'), $current_lang) ?> & <?= getPhaseTitreGoodies(__('final'), $current_lang) ?></h2>
                <p style="color:white;"><?= __('third_place_final_goodies') ?></p>
            </div>

            <div class="goodies-bloc" style="margin-bottom:32px;">
                <h2 style="color:#ffb300;"><?= __('best_predictor') ?></h2>
                <p style="color:white;"><?= __('best_predictor_goodies') ?></p>
            </div>
        </div>
    </div>
</div>

<script>
// Gestion des onglets avec Bootstrap
document.addEventListener('DOMContentLoaded', function() {
    var triggerTabList = [].slice.call(document.querySelectorAll('#reglementGoodiesTabs button'))
    triggerTabList.forEach(function (triggerEl) {
        var tabTrigger = new bootstrap.Tab(triggerEl)
        
        triggerEl.addEventListener('click', function (event) {
            event.preventDefault()
            tabTrigger.show()
        })
    })
});
</script>

<?php include 'templates/footer.php'; ?>
