<?php
// Inclure le système de langue en premier
require_once 'includes/language.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if(!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}
include 'templates/header.php';
require_once 'includes/db.php';
$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? '';

// Score personnel (corrigé)
function get_user_score_full($mysqli, $user_id) {
    // Points matchs + titulaires
    $stmt = $mysqli->prepare('SELECT SUM(points) as pts, SUM(IFNULL(titulaire_11,0)) as titulaires FROM match_points WHERE user_id = ?');
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
    $pts_matchs = $row['pts'] ?? 0;
    $pts_titulaires = $row['titulaires'] ?? 0;
    // Points groupes
    $stmt_gp = $mysqli->prepare('SELECT SUM(points) as pts FROM groupe_points WHERE user_id = ?');
    $stmt_gp->bind_param('i', $user_id);
    $stmt_gp->execute();
    $result_gp = $stmt_gp->get_result();
    $row_gp = $result_gp->fetch_assoc();
    $stmt_gp->close();
    $pts_groupes = $row_gp['pts'] ?? 0;
    // Points vainqueur CAN
    $winner_team = null;
    $result = $mysqli->query('SELECT team FROM winner_result LIMIT 1');
    if ($row = $result->fetch_assoc()) {
        $winner_team = $row['team'];
    }
    $result->close();
    $points_vainqueur_can = file_exists('includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('includes/points_vainqueur_can.txt'))) : 100;
    $pts_vainqueur = 0;
    if ($winner_team) {
        $user_team = null;
        $stmt3 = $mysqli->prepare('SELECT team FROM winner_predictions WHERE user_id = ?');
        $stmt3->bind_param('i', $user_id);
        $stmt3->execute();
        $stmt3->bind_result($user_team);
        $stmt3->fetch();
        $stmt3->close();
        if ($user_team && $user_team === $winner_team) {
            $pts_vainqueur = $points_vainqueur_can;
        }
    }
    // Points quiz par phase
    // IMPORTANT: "Match pour la 3e place" n'est plus une phase de quiz séparée, elle est combinée avec "Finale"
    $quiz_phases = ['Phase de groupes', '8e de finale', 'Quart de finale', 'Demi-finale', 'Finale'];
    $total_quiz_score = 0;
    foreach ($quiz_phases as $phase) {
        $stmt_quiz = $mysqli->prepare('SELECT score FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
        $stmt_quiz->bind_param('is', $user_id, $phase);
        $stmt_quiz->execute();
        $result_quiz = $stmt_quiz->get_result();
        $row_quiz = $result_quiz->fetch_assoc();
        $stmt_quiz->close();
        $total_quiz_score += $row_quiz['score'] ?? 0;
    }
    
    // Vérifier aussi s'il y a un ancien score pour "Match pour la 3e place" et l'inclure dans "Finale"
    // (pour la compatibilité avec les données existantes)
    $phase_third = 'Match pour la 3e place';
    $stmt_quiz_old = $mysqli->prepare('SELECT score FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
    $stmt_quiz_old->bind_param('is', $user_id, $phase_third);
    $stmt_quiz_old->execute();
    $result_quiz_old = $stmt_quiz_old->get_result();
    $row_quiz_old = $result_quiz_old->fetch_assoc();
    $stmt_quiz_old->close();
    
    // Si un score existe pour "Match pour la 3e place" mais pas pour "Finale", l'inclure
    if ($row_quiz_old && $row_quiz_old['score']) {
        // Vérifier si "Finale" a déjà un score
        $phase_finale = 'Finale';
        $stmt_check_finale = $mysqli->prepare('SELECT score FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
        $stmt_check_finale->bind_param('is', $user_id, $phase_finale);
        $stmt_check_finale->execute();
        $result_check_finale = $stmt_check_finale->get_result();
        $row_check_finale = $result_check_finale->fetch_assoc();
        $stmt_check_finale->close();
        
        // Si "Finale" n'a pas de score, ajouter le score de "Match pour la 3e place"
        if (!$row_check_finale || !$row_check_finale['score']) {
            $total_quiz_score += $row_quiz_old['score'] ?? 0;
        }
    }
    return intval($pts_matchs) + intval($pts_titulaires) + intval($pts_groupes) + intval($pts_vainqueur) + intval($total_quiz_score);
}

// Score par phase
function get_user_score_by_phase($mysqli, $user_id) {
    $phases = [];
    $result = $mysqli->query('SELECT DISTINCT phase FROM Matches ORDER BY match_date ASC');
    while($row = $result->fetch_assoc()) {
        $phases[] = $row['phase'];
    }
    $result->close();
    $scores = [];
    foreach ($phases as $phase) {
        $stmt = $mysqli->prepare('SELECT SUM(mp.points + IFNULL(mp.titulaire_11,0)) as total FROM match_points mp JOIN Matches m ON m.id = mp.match_id WHERE mp.user_id = ? AND m.phase = ?');
        $stmt->bind_param('is', $user_id, $phase);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        $stmt->close();
        $scores[$phase] = intval($row['total'] ?? 0);
    }
    return $scores;
}

// Fonction helper pour traduire le nom de la phase
function translatePhaseName($phase_name) {
    switch($phase_name) {
        case 'Phase de groupes':
            return __('group_phase');
        case '8e de finale':
            return __('round_of_16');
        case 'Quart de finale':
            return __('quarter_final');
        case 'Demi-finale':
            return __('semi_final');
        case 'Match pour la 3e place':
            return __('third_place_match');
        case 'Finale':
            return __('final');
        default:
            return $phase_name;
    }
}

$my_score = get_user_score_full($mysqli, $user_id);
$my_scores_by_phase = get_user_score_by_phase($mysqli, $user_id);

$points_par_match = [];
$stmt = $mysqli->prepare('SELECT m.id, m.team_1, m.team_2, m.match_date, mp.points, IFNULL(mp.titulaire_11,0) as titulaire_11 FROM match_points mp JOIN Matches m ON m.id = mp.match_id WHERE mp.user_id = ? ORDER BY m.match_date');
$stmt->bind_param('i', $user_id);
$stmt->execute();
$result = $stmt->get_result();
while($row = $result->fetch_assoc()) {
    $points_par_match[] = $row;
}
$stmt->close();

// Récupérer points groupes
$stmt_gp = $mysqli->prepare('SELECT SUM(points) as pts FROM groupe_points WHERE user_id = ?');
$stmt_gp->bind_param('i', $user_id);
$stmt_gp->execute();
$result_gp = $stmt_gp->get_result();
$row_gp = $result_gp->fetch_assoc();
$pts_groupes = $row_gp['pts'] ?? 0;
$stmt_gp->close();
// Récupérer points vainqueur CAN
$winner_team = null;
$result = $mysqli->query('SELECT team FROM winner_result LIMIT 1');
if ($row = $result->fetch_assoc()) {
    $winner_team = $row['team'];
}
$result->close();
$points_vainqueur_can = file_exists('includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('includes/points_vainqueur_can.txt'))) : 100;
$pts_vainqueur = 0;
if ($winner_team) {
    $user_team = null;
    $stmt3 = $mysqli->prepare('SELECT team FROM winner_predictions WHERE user_id = ?');
    $stmt3->bind_param('i', $user_id);
    $stmt3->execute();
    $stmt3->bind_result($user_team);
    $stmt3->fetch();
    $stmt3->close();
    if ($user_team && $user_team === $winner_team) {
        $pts_vainqueur = $points_vainqueur_can;
    }
}
// Récupérer toutes les phases distinctes
$phases = [];
$result = $mysqli->query('SELECT DISTINCT phase FROM Matches ORDER BY match_date ASC');
while($row = $result->fetch_assoc()) {
    $phases[] = $row['phase'];
}
$result->close();
// Points par phase (pronostic, titulaires, total)
$phase_points = [];
foreach ($phases as $phase) {
    $stmt = $mysqli->prepare('SELECT SUM(mp.points) as pts_prono, SUM(IFNULL(mp.titulaire_11,0)) as pts_titulaires FROM match_points mp JOIN Matches m ON m.id = mp.match_id WHERE mp.user_id = ? AND m.phase = ?');
    $stmt->bind_param('is', $user_id, $phase);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
    $phase_points[$phase] = [
        'prono' => intval($row['pts_prono'] ?? 0),
        'titulaire' => intval($row['pts_titulaires'] ?? 0),
        'total' => intval($row['pts_prono'] ?? 0) + intval($row['pts_titulaires'] ?? 0)
    ];
}

// Ordre officiel des phases
$phases_officielles = [
    "Phase de groupes · Journée 1 sur 3",
    "Phase de groupes · Journée 2 sur 3",
    "Phase de groupes · Journée 3 sur 3",
    "8e de finale",
    "Quart de finale",
    "Demi-finale",
    "Match pour la 3e place",
    "Finale"
];
// Filtrer les phases présentes dans la base, dans l'ordre officiel
$phases_sorted = [];
foreach ($phases_officielles as $p) {
    if (isset($phase_points[$p])) $phases_sorted[] = $p;
}
foreach ($phase_points as $p => $v) {
    if (!in_array($p, $phases_sorted)) $phases_sorted[] = $p;
}

// Statistiques par ville
$villes = [];
$result = $mysqli->query("SELECT DISTINCT ville FROM Users WHERE ville IS NOT NULL AND ville != '' AND role = 'user' ORDER BY ville");
while ($row = $result->fetch_assoc()) {
    $villes[] = $row['ville'];
}
$result->close();

$stats_ville = [];
foreach ($villes as $ville) {
    $stmt = $mysqli->prepare("SELECT id FROM Users WHERE ville = ? AND role = 'user'");
    $stmt->bind_param('s', $ville);
    $stmt->execute();
    $result = $stmt->get_result();
    $user_ids = [];
    while ($row = $result->fetch_assoc()) {
        $user_ids[] = $row['id'];
    }
    $stmt->close();
    $nb_users = count($user_ids);
    $user_ids_str = $user_ids ? implode(',', $user_ids) : '0';
    $pts_matchs = $user_ids ? $mysqli->query("SELECT SUM(points + IFNULL(titulaire_11,0)) as pts FROM match_points WHERE user_id IN ($user_ids_str)")->fetch_assoc()['pts'] : 0;
    $pts_groupes = $user_ids ? $mysqli->query("SELECT SUM(points) as pts FROM groupe_points WHERE user_id IN ($user_ids_str)")->fetch_assoc()['pts'] : 0;
    $winner_team_row = $mysqli->query('SELECT team FROM winner_result LIMIT 1')->fetch_assoc();
    $winner_team = $winner_team_row ? $winner_team_row['team'] : null;
    $points_vainqueur_can = file_exists('includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('includes/points_vainqueur_can.txt'))) : 100;
    $pts_vainqueur = 0;
    if ($winner_team && $user_ids) {
        $row = $mysqli->query("SELECT COUNT(*) as nb FROM winner_predictions WHERE user_id IN ($user_ids_str) AND team = '$winner_team'")->fetch_assoc();
        $nb_gagnants = isset($row['nb']) ? $row['nb'] : (isset($row['COUNT(*)']) ? $row['COUNT(*)'] : 0);
        $pts_vainqueur = $nb_gagnants * $points_vainqueur_can;
    }
    $points_total = (int)$pts_matchs + (int)$pts_groupes + (int)$pts_vainqueur;
    // Score quizz par phase pour la ville
    // IMPORTANT: "Match pour la 3e place" n'est plus une phase de quiz séparée, elle est combinée avec "Finale"
    $quiz_phases = ['Phase de groupes', '8e de finale', 'Quart de finale', 'Demi-finale', 'Finale'];
    $quizz_ville = 0;
    if ($user_ids) {
        foreach ($quiz_phases as $phase) {
            $row = $mysqli->query("SELECT SUM(score) as total FROM quizz_results_phases WHERE user_id IN ($user_ids_str) AND phase = '$phase'")->fetch_assoc();
            $quizz_ville += (int)($row['total'] ?? 0);
        }
        // Vérifier aussi les anciens scores de "Match pour la 3e place" pour compatibilité
        $row_old = $mysqli->query("SELECT SUM(score) as total FROM quizz_results_phases WHERE user_id IN ($user_ids_str) AND phase = 'Match pour la 3e place'")->fetch_assoc();
        if ($row_old && $row_old['total']) {
            // Vérifier si "Finale" a déjà un score pour cette ville
            $row_finale_check = $mysqli->query("SELECT SUM(score) as total FROM quizz_results_phases WHERE user_id IN ($user_ids_str) AND phase = 'Finale'")->fetch_assoc();
            if (!$row_finale_check || !$row_finale_check['total']) {
                $quizz_ville += (int)($row_old['total'] ?? 0);
            }
        }
    }
    $points_total_with_quizz = $points_total + $quizz_ville;
    $stats_ville[] = [
        'ville' => $ville,
        'users' => $nb_users,
        'points_matchs' => (int)$pts_matchs,
        'points_groupes' => (int)$pts_groupes,
        'points_vainqueur' => (int)$pts_vainqueur,
        'points_quizz' => $quizz_ville,
        'points_total' => $points_total_with_quizz
    ];
}

// Trier les statistiques par ville par ordre décroissant des scores totaux
usort($stats_ville, function($a, $b) {
    return $b['points_total'] - $a['points_total'];
});

// Statistiques par département
$departements = [];
$result = $mysqli->query("SELECT DISTINCT departement FROM Users WHERE departement IS NOT NULL AND departement != '' AND role = 'user' ORDER BY departement");
while ($row = $result->fetch_assoc()) {
    $departements[] = $row['departement'];
}
$result->close();

$stats_departement = [];
foreach ($departements as $departement) {
    $stmt = $mysqli->prepare("SELECT id FROM Users WHERE departement = ? AND role = 'user'");
    $stmt->bind_param('s', $departement);
    $stmt->execute();
    $result = $stmt->get_result();
    $user_ids = [];
    while ($row = $result->fetch_assoc()) {
        $user_ids[] = $row['id'];
    }
    $stmt->close();
    $nb_users = count($user_ids);
    $user_ids_str = $user_ids ? implode(',', $user_ids) : '0';
    $pts_matchs = $user_ids ? $mysqli->query("SELECT SUM(points + IFNULL(titulaire_11,0)) as pts FROM match_points WHERE user_id IN ($user_ids_str)")->fetch_assoc()['pts'] : 0;
    $pts_groupes = $user_ids ? $mysqli->query("SELECT SUM(points) as pts FROM groupe_points WHERE user_id IN ($user_ids_str)")->fetch_assoc()['pts'] : 0;
    $winner_team_row = $mysqli->query('SELECT team FROM winner_result LIMIT 1')->fetch_assoc();
    $winner_team = $winner_team_row ? $winner_team_row['team'] : null;
    $points_vainqueur_can = file_exists('includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('includes/points_vainqueur_can.txt'))) : 100;
    $pts_vainqueur = 0;
    if ($winner_team && $user_ids) {
        $row = $mysqli->query("SELECT COUNT(*) as nb FROM winner_predictions WHERE user_id IN ($user_ids_str) AND team = '$winner_team'")->fetch_assoc();
        $nb_gagnants = isset($row['nb']) ? $row['nb'] : (isset($row['COUNT(*)']) ? $row['COUNT(*)'] : 0);
        $pts_vainqueur = $nb_gagnants * $points_vainqueur_can;
    }
    $points_total = (int)$pts_matchs + (int)$pts_groupes + (int)$pts_vainqueur;
    // Score quizz par phase pour le département
    // IMPORTANT: "Match pour la 3e place" n'est plus une phase de quiz séparée, elle est combinée avec "Finale"
    $quiz_phases = ['Phase de groupes', '8e de finale', 'Quart de finale', 'Demi-finale', 'Finale'];
    $quizz_departement = 0;
    if ($user_ids) {
        foreach ($quiz_phases as $phase) {
            $row = $mysqli->query("SELECT SUM(score) as total FROM quizz_results_phases WHERE user_id IN ($user_ids_str) AND phase = '$phase'")->fetch_assoc();
            $quizz_departement += (int)($row['total'] ?? 0);
        }
        // Vérifier aussi les anciens scores de "Match pour la 3e place" pour compatibilité
        $row_old = $mysqli->query("SELECT SUM(score) as total FROM quizz_results_phases WHERE user_id IN ($user_ids_str) AND phase = 'Match pour la 3e place'")->fetch_assoc();
        if ($row_old && $row_old['total']) {
            // Vérifier si "Finale" a déjà un score pour ce département
            $row_finale_check = $mysqli->query("SELECT SUM(score) as total FROM quizz_results_phases WHERE user_id IN ($user_ids_str) AND phase = 'Finale'")->fetch_assoc();
            if (!$row_finale_check || !$row_finale_check['total']) {
                $quizz_departement += (int)($row_old['total'] ?? 0);
            }
        }
    }
    $points_total_with_quizz = $points_total + $quizz_departement;
    $stats_departement[] = [
        'departement' => $departement,
        'users' => $nb_users,
        'points_matchs' => (int)$pts_matchs,
        'points_groupes' => (int)$pts_groupes,
        'points_vainqueur' => (int)$pts_vainqueur,
        'points_quizz' => $quizz_departement,
        'points_total' => $points_total_with_quizz
    ];
}

// Trier les statistiques par département par ordre décroissant des scores totaux
usort($stats_departement, function($a, $b) {
    return $b['points_total'] - $a['points_total'];
});

// Récupérer les scores de quizz par phase de l'utilisateur
// IMPORTANT: "Match pour la 3e place" n'est plus une phase de quiz séparée, elle est combinée avec "Finale"
$quiz_phases = ['Phase de groupes', '8e de finale', 'Quart de finale', 'Demi-finale', 'Finale'];
$quiz_scores_by_phase = [];
$total_quiz_score = 0;

foreach ($quiz_phases as $phase) {
    $stmt_quiz = $mysqli->prepare('SELECT score FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
    $stmt_quiz->bind_param('is', $user_id, $phase);
    $stmt_quiz->execute();
    $result_quiz = $stmt_quiz->get_result();
    $row_quiz = $result_quiz->fetch_assoc();
    $stmt_quiz->close();
    
    // Si aucun score trouvé pour cette phase, mettre 0
    $quiz_score_phase = $row_quiz ? $row_quiz['score'] : 0;
    
    // Pour "Finale", vérifier aussi s'il y a un ancien score pour "Match pour la 3e place"
    if ($phase === 'Finale' && !$quiz_score_phase) {
        $phase_third = 'Match pour la 3e place';
        $stmt_quiz_old = $mysqli->prepare('SELECT score FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
        $stmt_quiz_old->bind_param('is', $user_id, $phase_third);
        $stmt_quiz_old->execute();
        $result_quiz_old = $stmt_quiz_old->get_result();
        $row_quiz_old = $result_quiz_old->fetch_assoc();
        $stmt_quiz_old->close();
        
        if ($row_quiz_old && $row_quiz_old['score']) {
            $quiz_score_phase = $row_quiz_old['score'];
        }
    }
    
    $quiz_scores_by_phase[$phase] = $quiz_score_phase;
    $total_quiz_score += $quiz_score_phase;
}

// Score total incluant le quizz
$my_score_total = $my_score + $total_quiz_score;

// --- DEBUG : Affiche les valeurs SQL récupérées ---
$user_id = $_SESSION['user_id'];

// Score groupes
$req = $mysqli->prepare("SELECT SUM(points) as pts FROM groupe_points WHERE user_id = ?");
$req->bind_param('i', $user_id);
$req->execute();
$req->bind_result($score_groupes);
$req->fetch();
$req->close();
$score_groupes = $score_groupes ?? 0;

// Score par phase (toutes les phases disponibles)
$phases = [];
$result = $mysqli->query("SELECT DISTINCT phase FROM Matches ORDER BY match_date ASC");
while($row = $result->fetch_assoc()) {
    $phases[] = $row['phase'];
}
$result->close();

// Définir l'ordre logique des phases
$phase_order = [
    'Phase de groupes · Journée 1 sur 3',
    'Phase de groupes · Journée 2 sur 3', 
    'Phase de groupes · Journée 3 sur 3',
    '8èmes de finale',
    'Huitièmes de finale',
    '8e de finale',
    'Quarts de finale',
    'Quart de finale',
    'Demi-finales',
    'Demi-finale',
    'Match pour la 3e place',
    '3ème place',
    '3eme place',
    'Finale'
];

// Trier les phases selon l'ordre logique
$phases_ordered = [];
foreach ($phase_order as $ordered_phase) {
    foreach ($phases as $phase) {
        if (strpos($phase, $ordered_phase) !== false || $phase === $ordered_phase) {
            $phases_ordered[] = $phase;
            break;
        }
    }
}

// Ajouter les phases non reconnues à la fin
foreach ($phases as $phase) {
    if (!in_array($phase, $phases_ordered)) {
        $phases_ordered[] = $phase;
    }
}

$phases = $phases_ordered;

$scores_par_phase = [];
foreach ($phases as $phase) {
    $req = $mysqli->prepare("SELECT SUM(mp.points) as prono, SUM(IFNULL(mp.titulaire_11,0)) as titulaires FROM match_points mp JOIN Matches m ON m.id = mp.match_id WHERE mp.user_id = ? AND m.phase = ?");
    $req->bind_param('is', $user_id, $phase);
    $req->execute();
    $req->bind_result($prono, $titulaires);
    $req->fetch();
    $req->close();
    
    // Créer un label plus lisible pour la phase et déterminer l'icône
    $label = $phase;
    $icon = 'fa-trophy'; // icône par défaut
    $current_lang = getCurrentLanguage();
    
    if (strpos($phase, 'Journée') !== false) {
        // Pour les journées de groupes
        $label = str_replace('Phase de groupes · ', '', $phase);
        // Traduire "Journée" et "sur"
        if ($current_lang === 'ar') {
            $label = str_replace('Journée', __('day'), $label);
            $label = str_replace('sur', __('of'), $label);
        }
        $icon = 'fa-calendar-day';
    } elseif (strpos($phase, '8èmes') !== false || strpos($phase, 'Huitièmes') !== false || strpos($phase, '8e de finale') !== false) {
        // 8èmes de finale
        $label = str_replace('Phase de groupes · ', '', $phase);
        $label = str_replace('Phase ', '', $label);
        $label = translatePhaseName('8e de finale');
        $icon = 'fa-flag';
    } elseif (strpos($phase, 'Quarts') !== false || strpos($phase, 'Quart de finale') !== false) {
        // Quarts de finale
        $label = str_replace('Phase de groupes · ', '', $phase);
        $label = str_replace('Phase ', '', $label);
        $label = translatePhaseName('Quart de finale');
        $icon = 'fa-medal';
    } elseif (strpos($phase, 'Demi') !== false) {
        // Demi-finales
        $label = str_replace('Phase de groupes · ', '', $phase);
        $label = str_replace('Phase ', '', $label);
        $label = translatePhaseName('Demi-finale');
        $icon = 'fa-trophy';
    } elseif (strpos($phase, 'Match pour la 3e place') !== false || strpos($phase, '3ème') !== false || strpos($phase, '3eme') !== false) {
        // 3ème place
        $label = str_replace('Phase de groupes · ', '', $phase);
        $label = str_replace('Phase ', '', $label);
        $label = translatePhaseName('Match pour la 3e place');
        $icon = 'fa-medal';
    } elseif (strpos($phase, 'Finale') !== false && strpos($phase, '3e') === false) {
        // Finale (mais pas la 3ème place)
        $label = str_replace('Phase de groupes · ', '', $phase);
        $label = str_replace('Phase ', '', $label);
        $label = translatePhaseName('Finale');
        $icon = 'fa-crown';
    } else {
        // Autres phases - essayer de traduire le nom de la phase
        $label = str_replace('Phase de groupes · ', '', $phase);
        $label = str_replace('Phase ', '', $label);
        $label = translatePhaseName($label);
    }
    
    $scores_par_phase[] = [
        'label' => $label,
        'icon' => $icon,
        'prono' => $prono ?? 0,
        'titulaires' => $titulaires ?? 0,
        'total' => ($prono ?? 0) + ($titulaires ?? 0)
    ];
}

// Score vainqueur CAN
$winner_team = null;
$res = $mysqli->query("SELECT team FROM winner_result LIMIT 1");
if ($row = $res->fetch_assoc()) $winner_team = $row['team'];
$res->close();
$score_vainqueur = 0;
if ($winner_team) {
    $req = $mysqli->prepare("SELECT team FROM winner_predictions WHERE user_id = ?");
    $req->bind_param('i', $user_id);
    $req->execute();
    $req->bind_result($user_team);
    $req->fetch();
    $req->close();
    $points_vainqueur_can = file_exists('includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('includes/points_vainqueur_can.txt'))) : 100;
    if ($user_team && $user_team === $winner_team) $score_vainqueur = $points_vainqueur_can;
}

// Score total
$score_total = $score_groupes + $score_vainqueur + $total_quiz_score;
foreach ($scores_par_phase as $phase) $score_total += $phase['total'];
?>
<style>
.container-score {
  max-width: 900px;
  margin: 0 auto;
  padding: 0 12px;
}
.mb-4 { margin-bottom: 32px !important; }
.table-responsive { overflow-x: auto; }

/* Styles RTL pour l'arabe */
.lang-ar .table th,
.lang-ar .table td {
    text-align: right;
}

.lang-ar h4,
.lang-ar h2 {
    text-align: center;
}

/* Style mobile pour le tr du thead */
@media (max-width: 768px) {
  .table thead tr {
    font-size: 12px;
  }
}
</style>

<h1 class="text-center mb-4" style="color: #ffffff; font-weight: 800;"><?= __('my_scores') ?></h1>

<div class="container-score" style="margin-top: 30px;">
  <!-- Bloc Score général -->
  <div class="mb-4">
    <!-- Tableau de score principal -->
    <div class="table-responsive">
      <table class="table table-dark table-striped table-bordered" style="margin:auto;">
        <thead>
          <tr>
            <th><?= __('category') ?></th>
            <th><?= __('prediction_score') ?></th>
            <th><?= __('starters_score') ?></th>
            <th><?= __('quiz_score') ?></th>
            <th><?= __('total_scores') ?></th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><i class="fa-solid fa-users"></i> <?= __('groups') ?></td>
            <td><?= $score_groupes ?></td>
            <td></td>
            <td></td>
            <td><?= $score_groupes ?></td>
          </tr>
          <?php foreach($scores_par_phase as $phase): ?>
          <tr>
            <td><i class="fa-solid <?= $phase['icon'] ?>"></i> <?= htmlspecialchars($phase['label']) ?></td>
            <td><?= $phase['prono'] ?></td>
            <td><?= $phase['titulaires'] ?></td>
            <td></td>
            <td><?= $phase['total'] ?></td>
          </tr>
          <?php endforeach; ?>
          <tr>
            <td><i class="fa-solid fa-crown"></i> <?= __('winner_can') ?></td>
            <td><?= $score_vainqueur ?></td>
            <td></td>
            <td></td>
            <td><?= $score_vainqueur ?></td>
          </tr>
          <?php foreach($quiz_scores_by_phase as $quiz_phase => $quiz_score): ?>
          <tr>
            <td><i class="fa-solid fa-graduation-cap"></i> <?= __('quiz') ?> <?= htmlspecialchars(translatePhaseName($quiz_phase)) ?></td>
            <td></td>
            <td></td>
            <td><?= $quiz_score ?></td>
            <td><?= $quiz_score ?></td>
          </tr>
          <?php endforeach; ?>
          <tr style="font-weight:bold;">
            <td><?= __('general_total') ?></td>
            <td colspan="3"></td>
            <td><?= $score_total ?></td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Bloc Statistiques par ville -->
  <?php if (!empty($stats_ville)): ?>
  <div class="mb-4">
    <h2 class="mb-4" style="color: white;"><?= __('statistics_by_city') ?></h2>
    <div class="table-responsive">
      <table class="table table-bordered table-striped bg-white">
        <thead class="table-dark">
          <tr>
            <th><?= __('city') ?></th>
            <th><?= __('users') ?></th>
            <th><?= __('match_predictions_score') ?></th>
            <th><?= __('group_predictions_score') ?></th>
            <th><?= __('winner_predictions_score') ?></th>
            <th><?= __('quiz_score') ?></th>
            <th><?= __('total_scores_site') ?></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($stats_ville as $row): ?>
            <tr>
              <td><?= htmlspecialchars($row['ville']) ?></td>
              <td><?= $row['users'] ?></td>
              <td><?= $row['points_matchs'] ?></td>
              <td><?= $row['points_groupes'] ?></td>
              <td><?= $row['points_vainqueur'] ?></td>
              <td><?= $row['points_quizz'] ?></td>
              <td><?= $row['points_total'] ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
  <?php endif; ?>

  <!-- Bloc Statistiques par département -->
  <?php if (!empty($stats_departement)): ?>
  <div class="mb-4">
    <h2 class="mb-4" style="color: white;"><?= __('statistics_by_department') ?></h2>
    <div class="table-responsive">
      <table class="table table-bordered table-striped bg-white">
        <thead class="table-dark">
          <tr>
            <th><?= __('department') ?></th>
            <th><?= __('users') ?></th>
            <th><?= __('match_predictions_score') ?></th>
            <th><?= __('group_predictions_score') ?></th>
            <th><?= __('winner_predictions_score') ?></th>
            <th><?= __('quiz_score') ?></th>
            <th><?= __('total_scores_site') ?></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($stats_departement as $row): ?>
            <tr>
              <td><?= htmlspecialchars($row['departement']) ?></td>
              <td><?= $row['users'] ?></td>
              <td><?= $row['points_matchs'] ?></td>
              <td><?= $row['points_groupes'] ?></td>
              <td><?= $row['points_vainqueur'] ?></td>
              <td><?= $row['points_quizz'] ?></td>
              <td><?= $row['points_total'] ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
  <?php endif; ?>
</div>
<?php include 'templates/footer.php'; ?> 