<?php
// Détecte le chemin racine du projet pour les assets
$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');

if (session_status() === PHP_SESSION_NONE) session_start();

// Inclure le système de langue
require_once __DIR__ . '/../includes/language.php';

$role = $_SESSION['role'] ?? null;
$script = basename($_SERVER['SCRIPT_NAME']);
$username = isset($_SESSION['username']) ? $_SESSION['username'] : '';
$current_lang = getCurrentLanguage();
$text_direction = getTextDirection();

// Récupérer la photo de l'utilisateur si connecté et vérifier si l'utilisateur est bloqué
$user_photo = null;
if (isset($_SESSION['user_id'])) {
    require_once __DIR__ . '/../includes/db.php';
    
    // Vérifier si le champ is_blocked existe
    $checkColumn = $mysqli->query("SHOW COLUMNS FROM Users LIKE 'is_blocked'");
    $hasIsBlocked = $checkColumn->num_rows > 0;
    
    // Récupérer la photo et le statut bloqué
    $sql = 'SELECT photo';
    if ($hasIsBlocked) {
        $sql .= ', is_blocked';
    }
    $sql .= ' FROM Users WHERE id = ?';
    
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $user_data = $result->fetch_assoc();
    $stmt->close();
    
    // Vérifier si l'utilisateur est bloqué (sauf pour les admins)
    if ($hasIsBlocked && isset($user_data['is_blocked']) && 
        ($user_data['is_blocked'] == 1 || $user_data['is_blocked'] === true) &&
        (!isset($_SESSION['role']) || ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'stat'))) {
        // Déconnecter l'utilisateur bloqué
        session_destroy();
        header('Location: ' . $base . '/welcome.php?blocked=1');
        exit;
    }
    
    $user_photo = $user_data['photo'] ?? null;
}
?>
<!DOCTYPE html>
<html lang="<?= $current_lang ?>" dir="<?= $text_direction ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CAN 2025 Pronostics</title>
    <link rel="stylesheet" href="<?= $base ?>/assets/style.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="<?= $base ?>/assets/app.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        .header-container {
            position: relative;
            z-index: 10000;
        }
        .language-selector {
            position: relative;
            display: inline-block;
            z-index: 9999;
        }
        .language-btn {
            background: none;
            border: 2px solid #fff;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            cursor: pointer;
            transition: all 0.3s ease;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0;
            position: relative;
            z-index: 10000;
        }
        .language-btn:hover {
            transform: scale(1.1);
            border-color: #ffb300;
            box-shadow: 0 0 10px rgba(255, 179, 0, 0.5);
        }
        .language-btn svg {
            width: 30px;
            height: 20px;
            border-radius: 2px;
            transition: transform 0.3s ease;
            pointer-events: none;
        }
        .language-btn:hover svg {
            transform: scale(1.05);
        }
        .language-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            background: rgba(0,0,0,0.95);
            border-radius: 8px;
            padding: 8px 0;
            min-width: 140px;
            z-index: 9998;
            display: none;
            box-shadow: 0 4px 20px rgba(0,0,0,0.3);
            border: 1px solid rgba(255,255,255,0.1);
        }
        .language-dropdown.show {
            display: block;
            animation: fadeInDown 0.3s ease;
        }
        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .language-option {
            display: flex;
            align-items: center;
            padding: 10px 16px;
            color: white;
            text-decoration: none;
            transition: all 0.3s ease;
            border-radius: 4px;
            margin: 2px 8px;
            cursor: pointer;
            user-select: none;
            position: relative;
            z-index: 9999;
        }
        .language-option:hover {
            background-color: rgba(255,179,0,0.2);
            color: #ffb300;
            text-decoration: none;
            transform: translateX(5px);
        }
        .language-option svg {
            width: 20px;
            height: 13px;
            margin-right: 12px;
            border-radius: 2px;
            flex-shrink: 0;
            pointer-events: none;
        }
        .language-option span {
            font-weight: 500;
            font-size: 14px;
            pointer-events: none;
        }
        .rtl {
            direction: rtl;
            text-align: right;
        }
        .ltr {
            direction: ltr;
            text-align: left;
        }
        
        /* Styles pour PC - centrer le sélecteur de langue */
        @media (min-width: 768px) {
            .header-container {
                position: relative;
            }
            
            .header-profile-section {
                flex: 1;
            }
            
            .header-profile-section .language-selector {
                position: absolute;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
                margin-left: 0;
            }
            
            /* Version arabe (RTL) - centrer le sélecteur de langue */
            .lang-ar .header-profile-section .language-selector {
                position: absolute;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
                margin-left: 0;
                margin-right: 0;
            }
            
            /* Ajuster le dropdown pour RTL */
            .lang-ar .language-dropdown {
                right: auto;
                left: 50%;
                transform: translateX(-50%);
            }
        }
        
        /* Styles pour mobile */
        @media (max-width: 767.98px) {
            .header-container {
                flex-direction: column;
                align-items: center;
                gap: 15px;
                position: relative;
            }
            
            .header-container .header-logo {
                order: 1;
                width: auto;
                max-width: 300px;
                height: auto;
                margin-bottom: 10px;
            }
            
            .header-logo {
                height: 50px !important;
                margin-left: -8px !important;
                margin-right: -21px !important;
            }
            
            .mt-4 {
                margin-top: -5rem !important;
            }
            
            .header-profile-section {
                order: 2;
                width: 100%;
                justify-content: space-between;
                align-items: center;
            }
            
            .header-profile-section .language-selector {
                position: static;
                margin-left: auto;
            }
            
            /* Version arabe (RTL) en mobile */
            .lang-ar .header-profile-section {
                flex-direction: row;
                justify-content: space-between;
                align-items: center;
            }
            
            .lang-ar .header-profile-section .language-selector {
                position: static;
                margin-left: 0;
                margin-right: auto;
            }
            
            .lang-ar .header-logo {
                height: 50px !important;
                margin-left: -21px !important;
                margin-right: -8px !important;
            }
        }
        
        /* Styles supplémentaires pour mobile */
        @media (max-width: 767.98px) {
            .mt-4 {
                margin-top: -5rem !important;
            }
            
            .header-logo {
                height: 50px !important;
                margin-left: -8px !important;
                margin-right: -21px !important;
            }
            
            .lang-ar .header-logo {
                height: 50px !important;
                margin-left: -21px !important;
                margin-right: -8px !important;
            }
        }
    </style>
</head>
<body class="<?= getLanguageClass() ?>">
<div class="header-img-mobile d-md-none"></div>

<div class="container mt-4"> 
<?php if (!in_array($script, ['index.php', 'welcome.php'])): ?>
  <div class="header-container w-100 d-flex align-items-center justify-content-between px-4 py-3" style="max-width: 950px;position: relative;margin: auto; z-index: 1;">
    <div class="d-flex align-items-center gap-2 header-profile-section">
      <!-- Icône profil cliquable -->
      <img src="assets/img/ico_menu.png" alt="Profil" id="menuProfileBtn" style="height: 32px; width: 32px; border-radius: 50%; margin-right: 8px; cursor:pointer;">
      <?php if($username): ?>
        <span class="bienvenue-user" style="display: flex; flex-direction: column; align-items: flex-start;">
          <span>
            <span class="bienvenue-label" style="color:white;"><?= __('welcome') ?></span>
            <a href="profile.php" class="bienvenue-nom" style="color: white; text-decoration: none; cursor: pointer; position: relative;" title="<?= __('profile') ?>">
              <?= htmlspecialchars($username) ?>
              <?php if (!$user_photo): ?>
                <span class="profile-indicator" style="position: absolute; top: -5px; right: -8px; width: 8px; height: 8px; background: #ffb300; border-radius: 50%; border: 1px solid white;" title="Complétez votre profil"></span>
              <?php endif; ?>
            </a>
          </span>
          <?php if (!in_array($script, ['home.php'])): ?>
            <a href="home.php" style="color:#ffb300; font-weight:600; font-size:1.05rem; text-decoration:underline; margin-top:2px; text-decoration: none;" title="<?= __('back') ?>"><?= __('back') ?></a>
          <?php endif; ?>
        </span>
      <?php endif; ?>
      
      <!-- Sélecteur de langue -->
      <div class="language-selector">
        <button class="language-btn" id="languageBtn" type="button">
          <?php if ($current_lang === 'ar'): ?>
            <span style="color: white; font-weight: bold; font-size: 14px;">AR</span>
          <?php else: ?>
            <span style="color: white; font-weight: bold; font-size: 14px;">FR</span>
          <?php endif; ?>
        </button>
        <div class="language-dropdown" id="languageDropdown">
          <a href="#" class="language-option" data-lang="fr">
            <span style="color: white; font-weight: bold; font-size: 14px; margin-right: 8px;">FR</span>
            <span><?= __('french') ?></span>
          </a>
          <a href="#" class="language-option" data-lang="ar">
            <span style="color: white; font-weight: bold; font-size: 14px; margin-right: 8px;">AR</span>
            <span><?= __('arabic') ?></span>
          </a>
        </div>
      </div>
    </div>
    
    <img src="assets/img/Logo1.png" alt="Logo" class="header-logo">
  </div>
  <!-- Offcanvas menu -->
  <div class="offcanvas offcanvas-end text-bg-dark" tabindex="-1" id="profileMenuOffcanvas" aria-labelledby="profileMenuLabel">
    <div class="offcanvas-header">
      <h5 class="offcanvas-title" id="profileMenuLabel"><?= __('menu') ?></h5>
      <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
      <ul class="nav flex-column gap-2">
        <li class="nav-item mt-3"><a class="nav-link text-white" href="home.php"><?= __('home') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="profile.php"><?= __('profile') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="pronostic_vainqueur.php"><?= __('champion_can') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="pronostics_groupe.php"><?= __('group_ranking') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="pronostics_matchs.php"><?= __('matches') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="titulaires_vote.php"><?= __('eleven_starters') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="mur_message.php"><?= __('message_wall') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="quizz.php"><?= __('quiz') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="challenge_photos.php"><?= __('photo_challenge') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="score.php"><?= __('my_score_ranking') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="gagnants.php">🏆 <?= __('winners') ?></a></li>
        <li class="nav-item"><a class="nav-link text-white" href="reglement_goodies.php"><?= __('rules') ?> & <?= __('goodies') ?></a></li>
        <?php if(isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
        <li class="nav-item"><a class="nav-link text-warning" href="admin/titulaires.php"><?= __('manage_players') ?></a></li>
        <li class="nav-item"><a class="nav-link text-warning" href="admin/titulaires_match.php"><?= __('match_starters') ?></a></li>
        <?php endif; ?>
        <li class="nav-item mt-3"><a class="nav-link text-danger fw-bold" href="logout.php"><?= __('logout') ?></a></li>
      </ul>
    </div>
  </div>
  <script>
    $(document).ready(function() {
      console.log('Script de langue chargé');
      
      // Gestion du menu profil
      var profileOffcanvas = document.getElementById('profileMenuOffcanvas');
      var bsOffcanvas = new bootstrap.Offcanvas(profileOffcanvas);
      
      // Masquer le header quand le menu s'ouvre
      profileOffcanvas.addEventListener('show.bs.offcanvas', function () {
        $('body').addClass('offcanvas-open');
        $('.header-img-mobile').hide();
      });
      
      // Afficher le header quand le menu se ferme
      profileOffcanvas.addEventListener('hidden.bs.offcanvas', function () {
        $('body').removeClass('offcanvas-open');
        $('.header-img-mobile').show();
      });
      
      $('#menuProfileBtn').on('click', function() {
        bsOffcanvas.show();
      });
      
      // Gestion du sélecteur de langue
      $('#languageBtn').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        console.log('Bouton langue cliqué');
        $('#languageDropdown').toggleClass('show');
      });
      
      // Fermer le dropdown en cliquant ailleurs
      $(document).on('click', function(e) {
        if (!$(e.target).closest('.language-selector').length) {
          $('#languageDropdown').removeClass('show');
        }
      });
      
      // Changer de langue
      $('.language-option').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        var lang = $(this).data('lang');
        console.log('Changement de langue vers:', lang);
        
        // Afficher un indicateur de chargement
        $(this).text('Chargement...');
        
        $.ajax({
          url: 'ajax/change_language.php',
          type: 'POST',
          data: { language: lang },
          dataType: 'json',
          success: function(response) {
            console.log('Réponse:', response);
            if (response.success) {
              location.reload();
            } else {
              alert('Erreur lors du changement de langue: ' + (response.message || 'Erreur inconnue'));
            }
          },
          error: function(xhr, status, error) {
            console.error('Erreur AJAX:', error);
            alert('Erreur de connexion lors du changement de langue');
          }
        });
      });
      
      // Debug: vérifier que les éléments existent
      console.log('Éléments trouvés:', {
        languageBtn: $('#languageBtn').length,
        languageDropdown: $('#languageDropdown').length,
        languageOptions: $('.language-option').length
      });
    });
  </script>
<?php endif; ?>
</body>
</html>