<?php
/**
 * Script de test de connexion MySQL
 * Teste différentes configurations pour identifier le problème
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Test de connexion MySQL - Diagnostic</h2>";
echo "<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    .success { color: green; padding: 10px; background: #d4edda; border: 1px solid #c3e6cb; margin: 10px 0; }
    .error { color: red; padding: 10px; background: #f8d7da; border: 1px solid #f5c6cb; margin: 10px 0; }
    .info { color: blue; padding: 10px; background: #d1ecf1; border: 1px solid #bee5eb; margin: 10px 0; }
    pre { background: #f4f4f4; padding: 10px; border: 1px solid #ddd; }
</style>";

// Configurations à tester
$configs = [
    [
        'name' => 'Configuration 1: IP du serveur',
        'host' => '197.230.98.25',
        'port' => 3306,
        'db' => 'footscor_bmci_pronostic',
        'user' => 'footscor_tarik',
        'pass' => '@LBdream258'
    ],
    [
        'name' => 'Configuration 2: Domaine principal',
        'host' => 'footscore.ma',
        'port' => 3306,
        'db' => 'footscor_bmci_pronostic',
        'user' => 'footscor_tarik',
        'pass' => '@LBdream258'
    ],
    [
        'name' => 'Configuration 3: localhost (si sur le serveur)',
        'host' => 'localhost',
        'port' => 3306,
        'db' => 'footscor_bmci_pronostic',
        'user' => 'footscor_tarik',
        'pass' => '@LBdream258'
    ],
    [
        'name' => 'Configuration 4: localhost avec socket',
        'host' => 'localhost',
        'port' => null, // Utilise le socket Unix par défaut
        'db' => 'footscor_bmci_pronostic',
        'user' => 'footscor_tarik',
        'pass' => '@LBdream258'
    ],
    [
        'name' => 'Configuration 5: 127.0.0.1',
        'host' => '127.0.0.1',
        'port' => 3306,
        'db' => 'footscor_bmci_pronostic',
        'user' => 'footscor_tarik',
        'pass' => '@LBdream258'
    ]
];

$successful_config = null;

foreach ($configs as $config) {
    echo "<div class='info'><strong>{$config['name']}</strong></div>";
    echo "<pre>";
    echo "Host: {$config['host']}\n";
    echo "Port: " . ($config['port'] ?? 'default') . "\n";
    echo "Database: {$config['db']}\n";
    echo "User: {$config['user']}\n";
    echo "Password: " . str_repeat('*', strlen($config['pass'])) . "\n";
    echo "</pre>";
    
    // Test de connexion
    $mysqli = null;
    try {
        if ($config['port'] === null) {
            $mysqli = new mysqli($config['host'], $config['user'], $config['pass'], $config['db']);
        } else {
            $mysqli = new mysqli($config['host'], $config['user'], $config['pass'], $config['db'], $config['port']);
        }
        
        if ($mysqli->connect_errno) {
            echo "<div class='error'>";
            echo "<strong>❌ ÉCHEC:</strong> Erreur de connexion ({$mysqli->connect_errno}): {$mysqli->connect_error}";
            echo "</div>";
        } else {
            echo "<div class='success'>";
            echo "<strong>✅ SUCCÈS!</strong> Connexion établie avec succès!";
            echo "</div>";
            
            // Test de requête
            $result = $mysqli->query("SELECT VERSION() as version, DATABASE() as db");
            if ($result) {
                $row = $result->fetch_assoc();
                echo "<div class='success'>";
                echo "Version MySQL: {$row['version']}<br>";
                echo "Base de données connectée: {$row['db']}";
                echo "</div>";
                
                // Test de tables
                $tables = $mysqli->query("SHOW TABLES");
                if ($tables) {
                    $table_count = $tables->num_rows;
                    echo "<div class='success'>";
                    echo "Nombre de tables trouvées: {$table_count}";
                    echo "</div>";
                }
            }
            
            $mysqli->close();
            $successful_config = $config;
            echo "<hr>";
            break; // Arrêter après le premier succès
        }
    } catch (Exception $e) {
        echo "<div class='error'>";
        echo "<strong>❌ EXCEPTION:</strong> " . $e->getMessage();
        echo "</div>";
    }
    
    echo "<hr>";
}

// Résumé et recommandations
echo "<h3>Résumé</h3>";
if ($successful_config) {
    echo "<div class='success'>";
    echo "<strong>✅ Configuration fonctionnelle trouvée!</strong><br>";
    echo "Utilisez cette configuration dans votre fichier db.php:<br>";
    echo "<pre>";
    echo "\$host = '{$successful_config['host']}';";
    if ($successful_config['port'] !== null) {
        echo "\n\$port = {$successful_config['port']};";
    }
    echo "\n\$db = '{$successful_config['db']}';";
    echo "\n\$user = '{$successful_config['user']}';";
    echo "\n\$pass = '{$successful_config['pass']}';";
    echo "</pre>";
    echo "</div>";
} else {
    echo "<div class='error'>";
    echo "<strong>❌ Aucune configuration n'a fonctionné.</strong><br><br>";
    echo "<strong>Vérifications à faire:</strong><br>";
    echo "1. Vérifiez que les connexions distantes MySQL sont activées dans cPanel:<br>";
    echo "   - Allez dans cPanel > Remote MySQL<br>";
    echo "   - Ajoutez votre IP publique (ou % pour toutes les IPs)<br><br>";
    echo "2. Vérifiez le nom d'hôte MySQL dans cPanel:<br>";
    echo "   - Allez dans cPanel > Bases de données MySQL<br>";
    echo "   - Regardez la section 'Informations de connexion'<br>";
    echo "   - Le nom d'hôte peut être 'localhost' ou un nom spécifique<br><br>";
    echo "3. Vérifiez que le firewall n'bloque pas le port 3306<br><br>";
    echo "4. Vérifiez les identifiants de la base de données:<br>";
    echo "   - Nom de la base: footscor_bmci_pronostic<br>";
    echo "   - Utilisateur: footscor_tarik<br>";
    echo "   - Mot de passe: @LBdream258<br><br>";
    echo "5. Si vous êtes sur le serveur lui-même, utilisez 'localhost'<br>";
    echo "</div>";
}

// Informations système
echo "<h3>Informations système</h3>";
echo "<pre>";
echo "PHP Version: " . PHP_VERSION . "\n";
echo "MySQLi disponible: " . (extension_loaded('mysqli') ? 'Oui' : 'Non') . "\n";
echo "Adresse IP locale: " . ($_SERVER['SERVER_ADDR'] ?? 'N/A') . "\n";
echo "Nom d'hôte serveur: " . ($_SERVER['SERVER_NAME'] ?? 'N/A') . "\n";
echo "</pre>";
?>
