<?php
// Inclure le système de langue en premier
require_once 'includes/language.php';

// Vérifier la session utilisateur
if(!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

include 'templates/header.php';
require_once 'includes/db.php';

// Traductions des noms d'équipes en arabe
$equipes_ar = [
    'Maroc' => 'المغرب', 'Comores' => 'جزر القمر', 'Mali' => 'مالي', 'Zambie' => 'زامبيا',
    'Afrique du Sud' => 'جنوب أفريقيا', 'Angola' => 'أنغولا', 'Égypte' => 'مصر', 'Zimbabwe' => 'زيمبابوي',
    'Sénégal' => 'السنغال', 'Botswana' => 'بوتسوانا', 'Tunisie' => 'تونس', 'Ouganda' => 'أوغندا',
    'RD Congo' => 'جمهورية الكونغو الديمقراطية', 'Bénin' => 'بنين', 'Nigeria' => 'نيجيريا', 'Tanzanie' => 'تنزانيا',
    'Algérie' => 'الجزائر', 'Soudan' => 'السودان', 'Côte d\'Ivoire' => 'ساحل العاج', 'Mozambique' => 'موزمبيق',
    'Cameroun' => 'الكاميرون', 'Gabon' => 'الغابون', 'Burkina Faso' => 'بوركينا فاسو', 'Guinée Équatoriale' => 'غينيا الاستوائية'
];

// Mapping des drapeaux des équipes (même que get_dashboard.php)
$equipes_flags = [
    'Maroc' => 'ma',
    'Comores' => 'km',
    'Mali' => 'ml',
    'Zambie' => 'zm',
    'Afrique du Sud' => 'za',
    'Angola' => 'ao',
    'Égypte' => 'eg',
    'Zimbabwe' => 'zw',
    'Sénégal' => 'sn',
    'Botswana' => 'bw',
    'Tunisie' => 'tn',
    'Ouganda' => 'ug',
    'RD Congo' => 'cd',
    'Bénin' => 'bj',
    'Nigeria' => 'ng',
    'Tanzanie' => 'tz',
    'Algérie' => 'dz',
    'Soudan' => 'sd',
    'Côte d\'Ivoire' => 'ci',
    'Mozambique' => 'mz',
    'Cameroun' => 'cm',
    'Gabon' => 'ga',
    'Burkina Faso' => 'bf',
    'Guinée Équatoriale' => 'gq'
];

// Fonction pour obtenir le nom de l'équipe selon la langue
function getTeamName($team_name, $current_lang) {
    global $equipes_ar;
    if ($current_lang === 'ar') {
        return $equipes_ar[$team_name] ?? $team_name;
    } else {
        return $team_name;
    }
}

// Fonction pour obtenir l'URL du drapeau (même que get_dashboard.php)
function getTeamFlag($team_name) {
    global $equipes_flags;
    $code = $equipes_flags[$team_name] ?? 'un';
    return 'https://flagcdn.com/w80/' . $code . '.png';
}

$current_lang = getCurrentLanguage();

// Récupérer tous les matchs du Maroc
$res = $mysqli->query("SELECT id, team_1, team_2, match_date FROM Matches WHERE team_1 = 'Maroc' OR team_2 = 'Maroc' ORDER BY match_date");
$matches = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];
$res->close();

// Récupérer tous les joueurs du Maroc
$res_j = $mysqli->query("SELECT id, nom, nom_ar, poste, image FROM joueurs_maroc ORDER BY poste, nom");
$all_joueurs = $res_j ? $res_j->fetch_all(MYSQLI_ASSOC) : [];
$res_j->close();
$joueurs_by_id = [];
foreach ($all_joueurs as $j) {
    $joueurs_by_id[$j['id']] = $j;
}

// Organiser les joueurs par poste avec traduction
$postes = [
    'gardiens' => __('goalkeepers'),
    'défenseurs' => __('defenders'),
    'milieux de terrain' => __('midfielders'),
    'attaquants' => __('forwards')
];

?>
<style>
/* Style pour le bouton accordéon - texte blanc visible */
.accordion-button {
    color: white !important;
    background-color: #23232b !important;
    border: 1px solid rgba(255,255,255,0.2) !important;
}

.accordion-button:not(.collapsed) {
    color: white !important;
    background-color: #23232b !important;
    box-shadow: none;
}

.accordion-button:focus {
    box-shadow: 0 0 0 0.25rem rgba(255,255,255,0.25);
    border-color: rgba(255,255,255,0.3) !important;
}

.accordion-button::after {
    filter: brightness(0) invert(1);
}

/* Styles RTL pour l'arabe */
.lang-ar .accordion-button {
    text-align: right;
}

.lang-ar .card {
    direction: rtl;
}

.lang-ar .card img {
    margin-left: 16px !important;
    margin-right: 0 !important;
}

.lang-ar .badge {
    margin-left: 0 !important;
    margin-right: 8px !important;
}

.lang-ar .alert {
    text-align: right;
}

.lang-ar h5 {
    text-align: right;
}

.lang-ar .accordion-button .ms-3 {
    margin-right: 10px !important;
    margin-left: 0 !important;
}

.lang-ar .team-flag {
    margin-left: 8px !important;
    margin-right: 8px !important;
}
</style>

<div class="container py-4">
  <h2 class="mb-4 text-center" style="color:white;"><?= __('vote_starters') ?></h2>
  <?php if (empty($matches)): ?>
    <div class="alert alert-warning"><?= __('no_morocco_matches') ?></div>
  <?php else: ?>
    <div class="accordion" id="accordionTitulairesVote">
      <?php $idx = 0; foreach ($matches as $m): $idx++;
        $collapse_id = 'collapseMatch'.$m['id'];
        $heading_id = 'headingMatch'.$m['id'];
        $show = ($idx === 1) ? 'show' : '';
        $date = date('d/m/Y H:i', strtotime($m['match_date']));
        date_default_timezone_set('Etc/GMT-1');
        $match_time = strtotime($m['match_date']);
        $deadline_titulaires = $match_time - 2*3600; // 2 heures avant le match
        $now = time();
        $match_commence = ($now >= $match_time);
        
        // Récupérer les titulaires réels si le match a commencé
        $titulaires_reels = [];
        $titulaires_reels_by_nom = [];
        if ($match_commence) {
            $stmt_reels = $mysqli->prepare('SELECT joueur, poste FROM titulaires_reels WHERE match_id = ?');
            $stmt_reels->bind_param('i', $m['id']);
            $stmt_reels->execute();
            $result_reels = $stmt_reels->get_result();
            while($row_reel = $result_reels->fetch_assoc()) {
                $titulaires_reels[] = $row_reel;
                $titulaires_reels_by_nom[$row_reel['joueur']] = $row_reel;
            }
            $stmt_reels->close();
        }
        
        $votes = [];
        $res_votes = $mysqli->prepare('SELECT joueur, COUNT(*) as nb FROM titulaires WHERE match_id = ? GROUP BY joueur');
        $res_votes->bind_param('i', $m['id']);
        $res_votes->execute();
        $result_votes = $res_votes->get_result();
        while($row = $result_votes->fetch_assoc()) {
            $votes[$row['joueur']] = $row['nb'];
        }
        $res_votes->close();
        // Afficher les votes par défaut, les masquer 2 heures avant le match
        $afficher_votes = ($now < $deadline_titulaires);
      ?>
      <div class="accordion-item bg-dark text-white mb-4 shadow">
        <h2 class="accordion-header" id="<?= $heading_id ?>">
          <button class="accordion-button bg-dark text-white" type="button" data-bs-toggle="collapse" data-bs-target="#<?= $collapse_id ?>" aria-expanded="<?= $show?'true':'false' ?>" aria-controls="<?= $collapse_id ?>" style="font-size:1.2rem;">
            <!-- Structure mobile : date en haut, équipes en dessous -->
            <div class="d-md-none w-100" style="display: flex; flex-direction: column;">
              <span class="text-info w-100 text-center mb-2" style="color: white !important; font-weight: bold; font-size: 1rem;"><?= $date ?></span>
              <span class="d-flex align-items-center justify-content-center">
                <i class="fa-solid fa-trophy text-warning me-2"></i>
                <img src="<?= getTeamFlag($m['team_1']) ?>" alt="<?= $m['team_1'] ?>" class="team-flag" style="width: 40px; height: 30px; margin-right: 12px; border-radius: 4px; border: 2px solid rgba(255,255,255,0.3);">
                <span class="team-name"><?= htmlspecialchars(getTeamName($m['team_1'], $current_lang)) ?></span>
                <span class="vs-separator mx-3">vs</span>
                <img src="<?= getTeamFlag($m['team_2']) ?>" alt="<?= $m['team_2'] ?>" class="team-flag" style="width: 40px; height: 30px; margin-right: 12px; border-radius: 4px; border: 2px solid rgba(255,255,255,0.3);">
                <span class="team-name"><?= htmlspecialchars(getTeamName($m['team_2'], $current_lang)) ?></span>
              </span>
            </div>
            <!-- Structure desktop : équipes à gauche, date à droite -->
            <div class="d-none d-md-flex w-100 justify-content-between align-items-center">
              <span class="d-flex align-items-center">
                <i class="fa-solid fa-trophy text-warning me-2"></i>
                <img src="<?= getTeamFlag($m['team_1']) ?>" alt="<?= $m['team_1'] ?>" class="team-flag" style="width: 40px; height: 30px; margin-right: 12px; border-radius: 4px; border: 2px solid rgba(255,255,255,0.3);">
                <span class="team-name"><?= htmlspecialchars(getTeamName($m['team_1'], $current_lang)) ?></span>
                <span class="vs-separator mx-3">vs</span>
                <img src="<?= getTeamFlag($m['team_2']) ?>" alt="<?= $m['team_2'] ?>" class="team-flag" style="width: 40px; height: 30px; margin-right: 12px; border-radius: 4px; border: 2px solid rgba(255,255,255,0.3);">
                <span class="team-name"><?= htmlspecialchars(getTeamName($m['team_2'], $current_lang)) ?></span>
              </span>
              <span class="text-info ms-3" style="color: white !important; font-weight: bold;"><?= $date ?></span>
            </div>
          </button>
        </h2>
        <div id="<?= $collapse_id ?>" class="accordion-collapse collapse <?= $show ?>" aria-labelledby="<?= $heading_id ?>" data-bs-parent="#accordionTitulairesVote">
          <div class="accordion-body bg-dark">
            <?php if ($match_commence && !empty($titulaires_reels)): ?>
              <!-- Afficher les 11 titulaires réels -->
              <?php foreach ($postes as $poste_key => $poste_label): ?>
                <h5 class="mt-3 mb-2 text-info"><?= $poste_label ?></h5>
                <div class="row">
                  <?php 
                  // Filtrer les titulaires réels pour ce poste
                  $titulaires_ce_poste = array_filter($titulaires_reels, function($tr) use ($poste_key) {
                      return $tr['poste'] === $poste_key;
                  });
                  
                  foreach ($titulaires_ce_poste as $tr):
                    // Trouver le joueur dans all_joueurs pour obtenir l'image
                    $j = null;
                    foreach ($all_joueurs as $joueur) {
                        if ($joueur['nom'] === $tr['joueur'] && $joueur['poste'] === $tr['poste']) {
                            $j = $joueur;
                            break;
                        }
                    }
                    if (!$j) continue; // Si le joueur n'est pas trouvé, passer au suivant
                    $img_path = 'assets/titulaire/'.htmlspecialchars($j['poste']).'/'.htmlspecialchars($j['image']);
                    $nom_joueur = getPlayerName($j['nom'], $j['nom_ar'] ?? null);
                  ?>
                    <div class="col-12 col-md-6 col-lg-4 mb-3">
                      <div class="card bg-success text-white shadow-sm d-flex flex-row align-items-center p-2" style="border: 2px solid #28a745;">
                        <img src="<?= $img_path ?>" style="height:48px;width:48px;border-radius:50%;margin-right:16px;">
                        <div class="flex-grow-1">
                          <span class="fw-bold"><?= htmlspecialchars($nom_joueur) ?></span>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              <?php endforeach; ?>
            <?php else: ?>
              <!-- Afficher les messages si le match n'a pas commencé ou si pas de titulaires réels -->
              <?php if ($match_commence && empty($titulaires_reels)): ?>
                <!-- Match commencé mais pas de titulaires réels enregistrés -->
                <div class="alert alert-warning text-center mb-4"><?= ($current_lang === 'ar') ? 'لم يتم تحديد اللاعبين الأساسيين بعد' : 'Les 11 titulaires n\'ont pas encore été déterminés' ?></div>
              <?php elseif (!$match_commence): ?>
                <!-- Message pour les matchs qui n'ont pas encore commencé -->
                <div class="alert alert-info text-center mb-4"><?= ($current_lang === 'ar') ? 'سيتم عرض التشكيلة الأساسية الرسمية عند بداية المباراة' : 'Les 11 titulaires officiel seront affichés au début du match' ?></div>
              <?php endif; ?>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>
<?php include 'templates/footer.php'; ?> 