<?php $base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\'); ?>
<?php include 'templates/header.php'; ?>
<div class="header-img-mobile d-md-none"></div>
<div class="row justify-content-center align-items-center center-vh">
  <div class="col-md-7 col-lg-6">
    <div style="display: flex; justify-content: center; align-items: center; margin-bottom: 10px;">
      <img src="assets/img/Logo1.png" alt="Logo" class="logo-main">
    </div>
    <div class="card p-4 shadow-lg border-0">
      <!-- Centered Tabs -->
      <ul class="nav nav-pills mb-3" id="authTabs" role="tablist" style="border-bottom: 3px; display: flex; justify-content: center; width: 100%;">
        <li class="nav-item" role="presentation">
          <button class="nav-link active custom-tab" id="register-tab" data-bs-toggle="tab" data-bs-target="#registerTab"
            type="button" role="tab" aria-controls="registerTab" aria-selected="true">
            Inscription
          </button>
        </li>
        <li class="nav-item" role="presentation">
          <button class="nav-link custom-tab" id="login-tab" data-bs-toggle="tab" data-bs-target="#loginTab"
            type="button" role="tab" aria-controls="loginTab" aria-selected="false">
            Connexion
          </button>
        </li>
      </ul>
      <div class="tab-content" id="authTabsContent">
        <div class="tab-pane fade" id="loginTab" role="tabpanel" aria-labelledby="login-tab">
          <form id="loginForm">
            <div class="mb-3">
              <label for="email" class="form-label">Email</label>
              <input type="email" class="form-control form-control-lg" id="email" name="email" required>
            </div>
            <div class="mb-3">
              <label for="password" class="form-label">Mot de passe</label>
              <div class="input-group">
                <input type="password" class="form-control form-control-lg" id="password" name="password" required>
                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16" id="passwordIcon">
                    <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.88 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.88-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
                    <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
                  </svg>
                </button>
              </div>
            </div>
            <div class="mb-3 text-end">
              <a href="#" id="forgotPasswordLink" class="text-decoration-none" style="color: white;">
                <i class="fas fa-key me-1"></i>Mot de passe oublié ?
              </a>
            </div>
            <button type="submit" class="btn btn-primary btn-lg w-100" style="background-color: #ab2024; border-color: #ab2024;">Se connecter</button>
          </form>
        </div>
        <div class="tab-pane fade show active" id="registerTab" role="tabpanel" aria-labelledby="register-tab">
          <form id="registerForm">
            <div class="mb-3">
              <label for="reg_username" class="form-label">Nom & Prénom</label>
              <input type="text" class="form-control form-control-lg" id="reg_username" name="username" required>
            </div>
            <div class="mb-3">
              <label for="reg_email" class="form-label">Email professionnel BNP Paribas</label>
              <input type="email" class="form-control form-control-lg" id="reg_email" name="email" placeholder="prenom.nom@bnpparibas.com" required>
              <div class="form-text" style="color: #ffffff;">Votre email doit se terminer par @bnpparibas.com ou @externe.bnpparibas.com</div>
            </div>
            <div class="mb-3">
              <label for="reg_ville" class="form-label">Ville</label>
              <select class="form-select form-select-lg" id="reg_ville" name="ville">
                <option value="">-- Sélectionner une ville --</option>
                <option value="Casablanca">Casablanca</option>
                <option value="Rabat">Rabat</option>
                <option value="Fès">Fès</option>
                <option value="Marrakech">Marrakech</option>
                <option value="Agadir">Agadir</option>
                <option value="Tanger">Tanger</option>
                <option value="Meknès">Meknès</option>
                <option value="Oujda">Oujda</option>
                <option value="Kénitra">Kénitra</option>
                <option value="Tétouan">Tétouan</option>
                <option value="Safi">Safi</option>
                <option value="Mohammedia">Mohammedia</option>
                <option value="Khouribga">Khouribga</option>
                <option value="Beni Mellal">Beni Mellal</option>
                <option value="El Jadida">El Jadida</option>
                <option value="Taza">Taza</option>
                <option value="Nador">Nador</option>
                <option value="Settat">Settat</option>
                <option value="Larache">Larache</option>
                <option value="Ksar El Kebir">Ksar El Kebir</option>
                <option value="Khemisset">Khemisset</option>
                <option value="Guelmim">Guelmim</option>
                <option value="Berrechid">Berrechid</option>
                <option value="Ouarzazate">Ouarzazate</option>
                <option value="Errachidia">Errachidia</option>
                <option value="Essaouira">Essaouira</option>
                <option value="Dakhla">Dakhla</option>
                <option value="Laâyoune">Laâyoune</option>
                <option value="Tiznit">Tiznit</option>
                <option value="Sidi Kacem">Sidi Kacem</option>
                <option value="Azrou">Azrou</option>
                <option value="Ifrane">Ifrane</option>
                <option value="Chefchaouen">Chefchaouen</option>
                <option value="Autre">Autre</option>
              </select>
            </div>
            <div class="mb-3">
              <label for="reg_departement" class="form-label">Département</label>
              <select class="form-select form-select-lg" id="reg_departement" name="departement">
                <option value="">-- Sélectionner un département --</option>
                <option value="CREDIT CONSO">CREDIT CONSO</option>
                <option value="PRODUCTION &amp; APPUI COMMERCIAL">PRODUCTION &amp; APPUI COMMERCIAL</option>
                <option value="OPC">OPC</option>
                <option value="RESSOURCES HUMAINES">RESSOURCES HUMAINES</option>
                <option value="CORPORATE BANKING">CORPORATE BANKING</option>
                <option value="CONFORMITE">CONFORMITE</option>
                <option value="RETAIL BANKING">RETAIL BANKING</option>
                <option value="LEASING">LEASING</option>
                <option value="DSI">DSI</option>
                <option value="IMEX">IMEX</option>
                <option value="ACHATS">ACHATS</option>
                <option value="FINANCE PARTICIPATIVE">FINANCE PARTICIPATIVE</option>
                <option value="RECOUVREMENT">RECOUVREMENT</option>
                <option value="SECURITIES SERVICES">SECURITIES SERVICES</option>
                <option value="BANQUE PRIVEE">BANQUE PRIVEE</option>
                <option value="SECURITE PHYSIQUE">SECURITE PHYSIQUE</option>
                <option value="RISQUES">RISQUES</option>
                <option value="FINANCE">FINANCE</option>
                <option value="EXPERIENCE CLIENT &amp; QUALITE">EXPERIENCE CLIENT &amp; QUALITE</option>
                <option value="TRANSFORMATION ET EFFICACITE OPERATIONNELLE">TRANSFORMATION ET EFFICACITE OPERATIONNELLE</option>
                <option value="ALM TREASURY">ALM TREASURY</option>
                <option value="LOCAL CAPITAL MARKET">LOCAL CAPITAL MARKET</option>
                <option value="COMMUNICATION">COMMUNICATION</option>
                <option value="PROGRAMME SAB">PROGRAMME SAB</option>
                <option value="DIGITAL FACTORY">DIGITAL FACTORY</option>
                <option value="MONETIQUE">MONETIQUE</option>
                <option value="AFFAIRES JURIDIQUES">AFFAIRES JURIDIQUES</option>
                <option value="DIRECTION GENERALE">DIRECTION GENERALE</option>
                <option value="CDO">CDO</option>
                <option value="INSPECTION GENERALE">INSPECTION GENERALE</option>
                <option value="ENGAGEMENT">ENGAGEMENT</option>
                <option value="PILOTAGE STRATEGIQUE">PILOTAGE STRATEGIQUE</option>
                <option value="Association des Retraités BMCI">Association des Retraités BMCI</option>
              </select>
            </div>
            <div class="mb-3" style="display: none;">
              <label for="reg_site" class="form-label">Site</label>
              <select class="form-select form-select-lg" id="reg_site" name="site">
                <option value="Jorf">Jorf</option>
                <option value="Berrechid">Berrechid</option>
                <option value="Nador">Nador</option>
                <option value="Casa Siege">Casa Siege</option>
                <option value="Longometal Afrique">Longometal Afrique</option>
                <option value="la plateforme commerciale de Ain Sebaa">la plateforme commerciale de Ain Sebaa</option>
              </select>
            </div>
            <button type="submit" class="btn btn-success btn-lg w-100" style="background-color: #ab2024; border-color: #ab2024;">S'inscrire</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="footer-img-mobile d-md-none"></div>
<style>
  .input-group .btn {
    border: 1px solid #ced4da;
    border-left: none;
    background-color: #fff;
    color: #495057;
  }
  .input-group .btn:hover {
    background-color: #e9ecef;
    color: #495057;
  }
  .input-group .form-control:first-child {
    border-right: none;
  }
  .input-group .form-control:first-child:focus {
    border-right: none;
    z-index: 3;
  }
</style>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="assets/app.js"></script>
<script>
  const base = "<?= $base ?>";
  
  // Au chargement de la page, afficher un message si l'utilisateur vient de s'inscrire
  $(document).ready(function() {
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('registered') === '1') {
      // Basculer automatiquement vers l'onglet connexion
      $('#login-tab').tab('show');
      showToast('Inscription réussie ! Connectez-vous avec vos identifiants.', 'success');
    }
  });
  
  // Validation côté client pour l'email BNP Paribas
  $('#reg_email').on('input', function() {
    const email = $(this).val().toLowerCase().trim();
    const emailPattern = /^[a-zA-Z0-9._%+-]+@(bnpparibas|externe\.bnpparibas)\.com$/i;
    
    // Liste des emails autorisés en exception
    const exceptions = [
      'tarik@thedreamtouch.com',
      'shun@thedreamtouch.com',
      'tarikbaghati@gmail.com'
    ];
    
    // Vérifier si c'est une exception ou un email @bnpparibas.com ou @externe.bnpparibas.com
    const isValid = exceptions.includes(email) || emailPattern.test(email);
    
    if (email && !isValid) {
      $(this).addClass('is-invalid');
      if (!$('#email-error').length) {
        $(this).after('<div id="email-error" class="invalid-feedback" style="color: #ffc107 !important; display: block;">L\'email doit se terminer par @bnpparibas.com ou @externe.bnpparibas.com</div>');
      }
    } else {
      $(this).removeClass('is-invalid');
      $('#email-error').remove();
    }
  });
  
  // Fonction pour basculer la visibilité du mot de passe
  function togglePasswordVisibility(inputId, buttonId) {
    const input = document.getElementById(inputId);
    const icon = document.getElementById('passwordIcon');
    
    if (input.type === 'password') {
      input.type = 'text';
      icon.innerHTML = '<path d="M13.359 11.238C15.06 9.72 16 8 16 8s-3-5.5-8-5.5a7.028 7.028 0 0 0-2.79.588l.77.771A5.944 5.944 0 0 1 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.134 13.134 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5a7.028 7.028 0 0 1-2.79-.588l-.77.772A7.028 7.028 0 0 0 8 13.5c2.12 0 3.879-1.168 5.168-2.457a13.134 13.134 0 0 0 1.191-1.805z"/><path d="M11.297 9.176a3.5 3.5 0 0 0-4.474-4.474l.823.823a2.5 2.5 0 0 1 2.829 2.829l.822.822zm-2.943 1.299.822.822a3.5 3.5 0 0 1-4.474-4.474l.823.823a2.5 2.5 0 0 0 2.829 2.829z"/><path d="M3.35 5.47c-.18.16-.353.322-.518.487A13.134 13.134 0 0 0 1.172 8l.195.288c.335.48.83 1.12 1.465 1.755C4.121 11.332 5.881 12.5 8 12.5a7.028 7.028 0 0 0 2.79-.588l.77.772A7.028 7.028 0 0 1 8 13.5C5.879 13.5 4.12 12.332 2.831 11.457A13.134 13.134 0 0 1 1.172 8 13.134 13.134 0 0 1 3.35 5.47z"/><path d="M8 4.5a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zM5.5 8a2.5 2.5 0 1 1 5 0 2.5 2.5 0 0 1-5 0z"/>';
      icon.style.fill = '#28a745';
    } else {
      input.type = 'password';
      icon.innerHTML = '<path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.88 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.88-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/><path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>';
      icon.style.fill = '';
    }
  }

  // Événement pour basculer la visibilité du mot de passe de connexion
  $('#togglePassword').on('click', function() {
    togglePasswordVisibility('password', 'togglePassword');
  });
  
  $('#loginForm').on('submit', function(e) {
    e.preventDefault();
    // Ignorer les espaces au début et à la fin du mot de passe
    const passwordInput = $('#password');
    passwordInput.val(passwordInput.val().trim());
    
    $.post(base + '/ajax/login.php', $(this).serialize(), function(data) {
      if (data.success && data.redirect) window.location = data.redirect;
      else if (data.success) window.location = base + '/home.php';
      else showToast(data.message, 'danger');
    }, 'json');
  });
  
  // Gestion du lien "Mot de passe oublié"
  $('#forgotPasswordLink').on('click', function(e) {
    e.preventDefault();
    showForgotPasswordModal();
  });
  
  // Fonction pour afficher la modal de réinitialisation
  function showForgotPasswordModal() {
    const modalHtml = `
      <div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content">
            <div class="modal-header" style="background-color: #ab2024; color: white;">
              <h5 class="modal-title" id="forgotPasswordModalLabel">
                <i class="fas fa-key me-2"></i>Réinitialisation du mot de passe
              </h5>
              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <p class="text-muted mb-3">Saisissez votre adresse email pour recevoir un lien de réinitialisation.</p>
              <form id="forgotPasswordForm">
                <div class="mb-3">
                  <label for="forgotEmail" class="form-label">Adresse email</label>
                  <input type="email" class="form-control" id="forgotEmail" name="email" required>
                  <div class="form-text">L'email doit correspondre à votre compte</div>
                </div>
                <div class="d-grid">
                  <button type="submit" class="btn btn-primary" style="background-color: #ab2024; border-color: #ab2024;">
                    <i class="fas fa-paper-plane me-2"></i>Envoyer le lien de réinitialisation
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    `;
    
    // Supprimer la modal existante si elle existe
    $('#forgotPasswordModal').remove();
    
    // Ajouter la modal au body
    $('body').append(modalHtml);
    
    // Afficher la modal
    const modal = new bootstrap.Modal(document.getElementById('forgotPasswordModal'));
    modal.show();
    
    // Gestion du formulaire de réinitialisation
    $('#forgotPasswordForm').on('submit', function(e) {
      e.preventDefault();
      
      const email = $('#forgotEmail').val();
      if (!email) {
        showToast('Veuillez saisir votre adresse email.', 'danger');
        return;
      }
      
      // Afficher un loader
      const submitBtn = $(this).find('button[type="submit"]');
      const originalText = submitBtn.html();
      submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Envoi en cours...');
      
      $.post(base + '/ajax/forgot_password.php', { email: email }, function(data) {
        submitBtn.prop('disabled', false).html(originalText);
        
        if (data.success) {
          modal.hide();
          showToast(data.message, 'success');
        } else {
          showToast(data.message, 'danger');
        }
      }, 'json').fail(function() {
        submitBtn.prop('disabled', false).html(originalText);
        showToast('Erreur de connexion au serveur. Veuillez réessayer.', 'danger');
      });
    });
  }
  
  $('#registerForm').on('submit', function(e) {
    e.preventDefault();
    
    // Validation côté client de l'email
    const email = $('#reg_email').val().toLowerCase().trim();
    const emailPattern = /^[a-zA-Z0-9._%+-]+@(bnpparibas|externe\.bnpparibas)\.com$/i;
    
    // Liste des emails autorisés en exception
    const exceptions = [
      'tarik@thedreamtouch.com',
      'shun@thedreamtouch.com',
      'tarikbaghati@gmail.com'
    ];
    
    // Vérifier si c'est une exception ou un email @bnpparibas.com ou @externe.bnpparibas.com
    const isValid = exceptions.includes(email) || emailPattern.test(email);
    
    if (!isValid) {
      showToast('Veuillez utiliser une adresse email @bnpparibas.com ou @externe.bnpparibas.com', 'danger');
      $('#reg_email').addClass('is-invalid');
      return false;
    }
    
    // Afficher un loader pendant le traitement
    const submitBtn = $(this).find('button[type="submit"]');
    const originalText = submitBtn.html();
    submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Inscription en cours...');
    
    $.post(base + '/ajax/register.php', $(this).serialize(), function(data) {
      submitBtn.prop('disabled', false).html(originalText);
      
      if (data.success && data.redirect) {
        Swal.fire({
          icon: 'success',
          title: 'Inscription réussie !',
          html: data.message + '<br><br>' + 
                (data.show_password ? 
                  '<div class="alert alert-warning mt-3"><strong>Votre mot de passe temporaire :</strong><br><span style="font-size: 1.2em; font-family: monospace;">' + data.password + '</span><br><small>Conservez-le précieusement !</small></div>' : 
                  '<small>Vous pouvez maintenant vous connecter avec vos identifiants.</small>'),
          confirmButtonText: 'Se connecter',
          confirmButtonColor: '#3db568',
          allowOutsideClick: false
        }).then(() => {
          window.location = data.redirect;
        });
      } else if (data.success) {
        Swal.fire({
          icon: 'success',
          title: 'Inscription réussie !',
          text: 'Connectez-vous avec vos identifiants.',
          confirmButtonText: 'OK',
          confirmButtonColor: '#198754'
        });
      } else {
        showToast(data.message, 'danger');
      }
    }, 'json').fail(function() {
      submitBtn.prop('disabled', false).html(originalText);
      showToast('Erreur de connexion au serveur. Veuillez réessayer.', 'danger');
    });
  });
</script>
<?php include 'templates/footer.php'; ?>
